/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other.core.scheduler;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.quartz.exception.QuartzExecutionException;
import com.taotao.boot.job.quartz.other.core.handler.JobExecuteHandler;
import com.taotao.boot.job.quartz.other.core.utils.QuartzJobUtils;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class JobScheduler {
    private final Scheduler scheduler;

    public JobScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void add(Long jobId, String jobGroup, String jobParam, String jobBeanName, String cron, String misfirePolicy) {
        JobDetail jobDetail = JobBuilder.newJob(JobExecuteHandler.class).withIdentity(QuartzJobUtils.getJobKey(jobId, jobGroup)).usingJobData("PARAMETER", jobParam).usingJobData("JOB_BEAN_NAME", jobBeanName).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cron);
        cronScheduleBuilder = QuartzJobUtils.handleCronScheduleMisfirePolicy(misfirePolicy, cronScheduleBuilder);
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(QuartzJobUtils.getTriggerKey(jobId, jobGroup)).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void delete(Long jobId, String jobGroup) {
        try {
            this.scheduler.deleteJob(QuartzJobUtils.getJobKey(jobId, jobGroup));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void update(Long jobId, String jobGroup, String jobParam, String jobBeanName, String cron, String misfirePolicy) {
        try {
            JobKey jobKey = QuartzJobUtils.getJobKey(jobId, jobGroup);
            if (this.scheduler.checkExists(jobKey)) {
                this.scheduler.deleteJob(jobKey);
            }
            this.add(jobId, jobGroup, jobParam, jobBeanName, cron, misfirePolicy);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void pause(Long jobId, String jobGroup) {
        try {
            this.scheduler.pauseJob(QuartzJobUtils.getJobKey(jobId, jobGroup));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u6682\u505c\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void resumeJob(Long jobId, String jobGroup) {
        try {
            this.scheduler.resumeJob(QuartzJobUtils.getJobKey(jobId, jobGroup));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void trigger(Long jobId, String jobGroup) {
        try {
            this.scheduler.triggerJob(QuartzJobUtils.getJobKey(jobId, jobGroup));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6267\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u6267\u884c\u4e00\u6b21\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }
}

