/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other.core.support;

import com.taotao.boot.job.quartz.other.core.support.JobClassPathScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;

public class QuartzJobExporter
extends ApplicationObjectSupport
implements SmartInitializingSingleton {
    public void afterSingletonsInstantiated() {
        ApplicationContext applicationContext = this.getApplicationContext();
        assert (applicationContext != null);
        this.scanPackage(applicationContext);
    }

    private void scanPackage(ApplicationContext applicationContext) {
        ArrayList packages = new ArrayList();
        Map springBootApplicationBeans = applicationContext.getBeansWithAnnotation(SpringBootApplication.class);
        springBootApplicationBeans.values().forEach(bean -> {
            SpringBootApplication annotation = (SpringBootApplication)AnnotationUtils.findAnnotation(bean.getClass(), SpringBootApplication.class);
            assert (annotation != null);
            if (annotation.scanBasePackages().length != 0) {
                packages.addAll(Arrays.asList(annotation.scanBasePackages()));
            } else {
                String packageName = ClassUtils.getPackageName((String)bean.getClass().getName());
                packages.add(packageName);
            }
        });
        JobClassPathScanner scanner = new JobClassPathScanner((BeanDefinitionRegistry)applicationContext, false);
        scanner.doScan(packages.toArray(new String[0]));
    }
}

