/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other1.config;

import com.taotao.boot.job.quartz.other1.annotation.HoneyCronJob;
import com.taotao.boot.job.quartz.other1.annotation.HoneySimpleJob;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.quartz.JobDetail;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.util.ClassUtils;

public class HoneyJobRegistrar
implements EnvironmentAware,
ImportBeanDefinitionRegistrar {
    private Environment environment;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        if (importingClassMetadata.hasAnnotation(HoneySimpleJob.class.getName())) {
            this.processSimpleJob(importingClassMetadata, registry);
        } else if (importingClassMetadata.hasAnnotation(HoneyCronJob.class.getName())) {
            this.processCronJob(importingClassMetadata, registry);
        }
    }

    private void processSimpleJob(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class clazz;
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(HoneySimpleJob.class.getName()));
        if (null == annotationAttributes) {
            return;
        }
        String className = importingClassMetadata.getClassName();
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
        if (!QuartzJobBean.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException();
        }
        String jobGroup = this.resolvePlaceholder(annotationAttributes.getString("jobGroup"), true);
        String jobName = this.resolvePlaceholder(annotationAttributes.getString("jobName"), true);
        String triggerGroup = this.resolvePlaceholder(annotationAttributes.getString("triggerGroup"), true);
        String triggerName = this.resolvePlaceholder(annotationAttributes.getString("triggerName"), true);
        Date startTime = this.parseDateStr(this.resolvePlaceholder(annotationAttributes.getString("start"), false), true);
        Date endTime = this.parseDateStr(this.resolvePlaceholder(annotationAttributes.getString("end"), false), false);
        String interval = this.resolvePlaceholder(annotationAttributes.getString("repeatInterval"), false);
        long repeatInterval = StringUtils.isEmpty((CharSequence)interval) ? 0L : Long.parseLong(interval);
        String repeat = this.resolvePlaceholder(annotationAttributes.getString("repeatCount"), false);
        int repeatCount = StringUtils.isEmpty((CharSequence)repeat) ? -1 : Integer.parseInt(repeat);
        int misfire = (Integer)annotationAttributes.getNumber("misfire");
        AbstractBeanDefinition jobDetailBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(JobDetailFactoryBean.class).addPropertyValue("group", (Object)jobGroup).addPropertyValue("name", (Object)jobName).addPropertyValue("jobClass", (Object)clazz).addPropertyValue("durability", (Object)true).addPropertyValue("requestsRecovery", (Object)true).setScope("singleton").getBeanDefinition();
        registry.registerBeanDefinition(className, (BeanDefinition)jobDetailBeanDefinition);
        if (registry instanceof BeanFactory) {
            JobDetail jobDetail = (JobDetail)((BeanFactory)registry).getBean(className, JobDetail.class);
            AbstractBeanDefinition triggerBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(SimpleTriggerImpl.class).addPropertyValue("group", (Object)(StringUtils.isEmpty((CharSequence)triggerGroup) ? jobGroup : triggerGroup)).addPropertyValue("name", (Object)(StringUtils.isEmpty((CharSequence)triggerName) ? jobName : triggerName)).addPropertyValue("jobKey", (Object)jobDetail.getKey()).addPropertyValue("startTime", (Object)startTime).addPropertyValue("endTime", (Object)endTime).addPropertyValue("repeatInterval", (Object)repeatInterval).addPropertyValue("repeatCount", (Object)repeatCount).addPropertyValue("misfireInstruction", (Object)misfire).setScope("singleton").getBeanDefinition();
            registry.registerBeanDefinition(this.assembleTriggerBeanName(className), (BeanDefinition)triggerBeanDefinition);
        }
    }

    private void processCronJob(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Class clazz;
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(HoneyCronJob.class.getName()));
        if (null == annotationAttributes) {
            return;
        }
        String className = importingClassMetadata.getClassName();
        try {
            clazz = ClassUtils.forName((String)className, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
        if (!QuartzJobBean.class.isAssignableFrom(clazz)) {
            throw new IllegalStateException();
        }
        String jobGroup = this.resolvePlaceholder(annotationAttributes.getString("jobGroup"), true);
        String jobName = this.resolvePlaceholder(annotationAttributes.getString("jobName"), true);
        String triggerGroup = this.resolvePlaceholder(annotationAttributes.getString("triggerGroup"), true);
        String triggerName = this.resolvePlaceholder(annotationAttributes.getString("triggerName"), true);
        String cron = this.resolvePlaceholder(annotationAttributes.getString("cron"), true);
        Date startTime = this.parseDateStr(this.resolvePlaceholder(annotationAttributes.getString("start"), false), true);
        Date endTime = this.parseDateStr(this.resolvePlaceholder(annotationAttributes.getString("end"), false), false);
        int misfire = (Integer)annotationAttributes.getNumber("misfire");
        AbstractBeanDefinition jobDetailBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(JobDetailFactoryBean.class).addPropertyValue("group", (Object)jobGroup).addPropertyValue("name", (Object)jobName).addPropertyValue("jobClass", (Object)clazz).addPropertyValue("durability", (Object)true).addPropertyValue("requestsRecovery", (Object)true).setScope("singleton").getBeanDefinition();
        registry.registerBeanDefinition(className, (BeanDefinition)jobDetailBeanDefinition);
        if (registry instanceof BeanFactory) {
            JobDetail jobDetail = (JobDetail)((BeanFactory)registry).getBean(className, JobDetail.class);
            AbstractBeanDefinition triggerBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(CronTriggerImpl.class).addPropertyValue("group", (Object)(StringUtils.isEmpty((CharSequence)triggerGroup) ? jobGroup : triggerGroup)).addPropertyValue("name", (Object)(StringUtils.isEmpty((CharSequence)triggerName) ? jobName : triggerName)).addPropertyValue("jobKey", (Object)jobDetail.getKey()).addPropertyValue("startTime", (Object)startTime).addPropertyValue("endTime", (Object)endTime).addPropertyValue("cronExpression", (Object)cron).addPropertyValue("misfireInstruction", (Object)misfire).setScope("singleton").getBeanDefinition();
            registry.registerBeanDefinition(this.assembleTriggerBeanName(className), (BeanDefinition)triggerBeanDefinition);
        }
    }

    private String resolvePlaceholder(String text, boolean notAllowEmpty) {
        String resultText = text;
        if (StringUtils.isNotEmpty((CharSequence)resultText)) {
            resultText = this.environment.resolvePlaceholders(resultText);
        }
        if (notAllowEmpty && StringUtils.isEmpty((CharSequence)resultText)) {
            throw new IllegalStateException();
        }
        return resultText;
    }

    private Date parseDateStr(String dateStr, boolean nowWhenEmpty) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            return nowWhenEmpty ? new Date() : null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setLenient(false);
        try {
            return new Date(sdf.parse(dateStr).getTime());
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
    }

    private String assembleTriggerBeanName(String jobClassName) {
        return jobClassName + ".trigger";
    }
}

