/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other1.config;

import com.taotao.boot.job.quartz.other1.quartz.HoneyJobBeanFactory;
import java.util.List;
import java.util.Properties;
import org.quartz.JobDetail;
import org.quartz.Trigger;
import org.quartz.spi.JobFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
public class HoneySchedulerConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={SchedulerFactoryBean.class})
    public SchedulerFactoryBean SchedulerFactoryBean(List<JobDetail> jobDetails, List<Trigger> triggers, Properties schedulerProperties) {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setSchedulerName(schedulerProperties.getProperty("org.quartz.scheduler.instanceName", "honey-default-instance"));
        schedulerFactoryBean.setJobFactory((JobFactory)this.honeyJobBeanFactory());
        if (null != jobDetails && !jobDetails.isEmpty()) {
            schedulerFactoryBean.setJobDetails(jobDetails.toArray(new JobDetail[0]));
        }
        if (null != triggers && !triggers.isEmpty()) {
            schedulerFactoryBean.setTriggers(triggers.toArray(new Trigger[0]));
        }
        schedulerFactoryBean.setOverwriteExistingJobs(true);
        schedulerFactoryBean.setQuartzProperties(schedulerProperties);
        return schedulerFactoryBean;
    }

    @Bean
    public HoneyJobBeanFactory honeyJobBeanFactory() {
        return new HoneyJobBeanFactory();
    }
}

