/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.other1.config;

import com.taotao.boot.job.quartz.other1.properties.HoneySchedulerProperties;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={HoneySchedulerProperties.class})
public class HoneySchedulerPropertiesConfiguration {
    @Bean
    public Properties schedulerProperties(HoneySchedulerProperties honeySchedulerProperties) {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver(HoneySchedulerPropertiesConfiguration.class.getClassLoader());
        Properties honeyQuartzProperties = new Properties();
        try {
            honeyQuartzProperties.load(resourcePatternResolver.getResource("classpath:honey-quartz.properties").getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Properties ymlQuartzProperties = new Properties();
        Map<String, String> quartzProperties = honeySchedulerProperties.getQuartz();
        if (null != quartzProperties && !quartzProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : quartzProperties.entrySet()) {
                ymlQuartzProperties.put("org.quartz." + entry.getKey(), entry.getValue());
            }
        }
        CollectionUtils.mergePropertiesIntoMap((Properties)ymlQuartzProperties, (Map)honeyQuartzProperties);
        return honeyQuartzProperties;
    }
}

