/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.quartz.utils;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.quartz.entity.QuartzTask;
import com.taotao.boot.job.quartz.enums.ScheduleConcurrentEnum;
import com.taotao.boot.job.quartz.enums.ScheduleStatusEnum;
import com.taotao.boot.job.quartz.event.QuartzEvent;
import com.taotao.boot.job.quartz.exception.QuartzExecutionException;
import com.taotao.boot.job.quartz.execution.ScheduleConcurrentExecution;
import com.taotao.boot.job.quartz.execution.ScheduleDisallowConcurrentExecution;
import com.taotao.boot.job.quartz.utils.CronUtils;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.context.ApplicationEvent;

public class QuartzManager {
    private static final String JOB_NAME = "TASK_";
    private static final String TRIGGER_NAME = "TRIGGER_";
    @Resource(name="scheduler")
    private Scheduler scheduler;

    public void addJob(QuartzTask quartzTask) {
        try {
            JobKey jobKey = QuartzManager.getJobKey(quartzTask);
            JobDetail jobDetail = JobBuilder.newJob(QuartzManager.getJobClass(quartzTask)).withIdentity(jobKey).withDescription(quartzTask.getRemark()).storeDurably().build();
            CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)quartzTask.getCronExpression()).withMisfireHandlingInstructionDoNothing();
            TriggerKey triggerKey = QuartzManager.getTriggerKey(quartzTask);
            Trigger cronTrigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
            cronTrigger.getJobDataMap().put("JOB_KEY", (Object)quartzTask);
            ((CronTriggerImpl)cronTrigger).setStartTime(new Date());
            this.scheduler.scheduleJob(jobDetail, cronTrigger);
            if (this.scheduler.checkExists(jobKey)) {
                this.deleteJob(quartzTask);
            }
            if (CronUtils.getNextExecution(quartzTask.getCronExpression()) != null) {
                this.scheduler.scheduleJob(jobDetail, cronTrigger);
            }
            if (quartzTask.getState().equals(ScheduleStatusEnum.PAUSE.getValue())) {
                this.pauseJob(quartzTask);
            }
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzTask));
            LogUtils.info((String)"\u6dfb\u52a0Quartz\u5b9a\u65f6\u4efb\u52a1\u6210\u529f", (Object[])new Object[0]);
        }
        catch (Exception e) {
            LogUtils.error((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void updateJob(QuartzTask quartzTask) {
        try {
            if (this.checkExists(quartzTask)) {
                this.deleteJob(quartzTask);
            }
        }
        catch (SchedulerException e) {
            throw new RuntimeException("\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", e);
        }
        this.addJob(quartzTask);
    }

    public boolean checkExists(QuartzTask quartzTask) throws SchedulerException {
        return this.scheduler.checkExists(QuartzManager.getJobKey(quartzTask));
    }

    public void deleteJob(QuartzTask quartzTask) {
        try {
            this.scheduler.pauseJob(QuartzManager.getJobKey(quartzTask));
            this.scheduler.deleteJob(QuartzManager.getJobKey(quartzTask));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzTask));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void resumeJob(QuartzTask quartzTask) {
        try {
            this.scheduler.resumeJob(QuartzManager.getJobKey(quartzTask));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzTask));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u6062\u590d\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25");
        }
    }

    public void runJobNow(QuartzTask quartzTask) {
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("JOB_KEY", (Object)quartzTask);
            if (this.checkExists(quartzTask)) {
                this.scheduler.triggerJob(QuartzManager.getJobKey(quartzTask), dataMap);
            }
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzTask));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25");
        }
    }

    public void pauseJob(QuartzTask quartzTask) {
        try {
            this.scheduler.pauseJob(QuartzManager.getJobKey(quartzTask));
            ContextUtils.publishEvent((ApplicationEvent)new QuartzEvent(quartzTask));
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25", (Object[])new Object[]{e});
            throw new QuartzExecutionException("\u5b9a\u65f6\u4efb\u52a1\u6682\u505c\u5931\u8d25");
        }
    }

    public Class<? extends Job> getJobClass(String classname) {
        Class<?> clazz;
        try {
            clazz = Class.forName(classname);
        }
        catch (ClassNotFoundException e) {
            throw new QuartzExecutionException("\u627e\u4e0d\u5230\u8be5\u5b9a\u65f6\u4efb\u52a1\u7c7b\u540d");
        }
        if (Job.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        throw new QuartzExecutionException("\u8be5\u7c7b\u4e0d\u662f\u5b9a\u65f6\u4efb\u52a1\u7c7b");
    }

    public static Class<? extends Job> getJobClass(QuartzTask quartzTask) {
        if (quartzTask.getConcurrent().equals(ScheduleConcurrentEnum.NO.getValue())) {
            return ScheduleDisallowConcurrentExecution.class;
        }
        return ScheduleConcurrentExecution.class;
    }

    public static TriggerKey getTriggerKey(QuartzTask quartzTask) {
        return TriggerKey.triggerKey((String)(TRIGGER_NAME + quartzTask.getId()), (String)quartzTask.getGroupName());
    }

    public static JobKey getJobKey(QuartzTask quartzTask) {
        return JobKey.jobKey((String)(JOB_NAME + quartzTask.getId()), (String)quartzTask.getGroupName());
    }

    public void startAllJobs() {
        try {
            this.scheduler.start();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5f00\u542f\u6240\u6709\u7684\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void pauseAll() {
        try {
            this.scheduler.pauseAll();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6682\u505c\u6240\u6709\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void resumeAll() {
        try {
            this.scheduler.resumeAll();
        }
        catch (Exception e) {
            LogUtils.error((String)"\u6062\u590d\u6240\u6709\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public void shutdownAll() {
        try {
            if (!this.scheduler.isShutdown()) {
                this.scheduler.shutdown(true);
            }
        }
        catch (Exception e) {
            LogUtils.error((String)"\u5173\u95ed\u6240\u6709\u7684\u4efb\u52a1\u5931\u8d25", (Object[])new Object[]{e});
        }
    }

    public List<Trigger> findTriggers() {
        try {
            GroupMatcher matcher = GroupMatcher.anyJobGroup();
            Set jobKeys = this.scheduler.getJobKeys(matcher);
            return jobKeys.stream().map(this::getTriggersOfJob).flatMap(Collection::stream).collect(Collectors.toList());
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
            throw new QuartzExecutionException(e.getMessage());
        }
    }

    private List<? extends Trigger> getTriggersOfJob(JobKey jobKey) {
        try {
            return this.scheduler.getTriggersOfJob(jobKey);
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
            throw new QuartzExecutionException(e);
        }
    }

    public void deleteTrigger(String triggerName) {
        try {
            this.scheduler.unscheduleJob(TriggerKey.triggerKey((String)triggerName));
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
        }
    }

    public void clear() {
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException e) {
            LogUtils.error((Throwable)e);
        }
    }
}

