/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.schedule.properties.ScheduledProperties;
import com.taotao.boot.job.schedule.task.TaskManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@AutoConfiguration
@EnableScheduling
@ConditionalOnProperty(prefix="taotao.boot.job.scheduled", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={ScheduledProperties.class})
public class ScheduledAutoConfiguration
implements SchedulingConfigurer,
InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ScheduledAutoConfiguration.class, (String)"taotao-boot-starter-job-schedule", (String[])new String[0]);
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(20);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("ttc-scheduled-task");
        taskScheduler.setErrorHandler(LogUtils::error);
        taskScheduler.setWaitForTasksToCompleteOnShutdown(true);
        taskScheduler.setAwaitTerminationSeconds(50);
        taskScheduler.initialize();
        taskRegistrar.setTaskScheduler((TaskScheduler)taskScheduler);
    }

    @Bean
    public TaskManager scheduledTaskManager() {
        return new TaskManager();
    }
}

