/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.schedule.configuration.ScheduledAutoConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.redis.spring.RedisLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@AutoConfiguration
@EnableSchedulerLock(defaultLockAtMostFor="PT60S")
@ConditionalOnProperty(prefix="taotao.boot.job.scheduled", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class ShedLockRedisAutoConfiguration
implements InitializingBean {
    @Value(value="${spring.profiles.active}")
    private String env;

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ScheduledAutoConfiguration.class, (String)"taotao-boot-starter-job-schedule", (String[])new String[0]);
    }

    @Bean
    public LockProvider lockProvider(RedissonConnectionFactory connectionFactory) {
        return new RedisLockProvider((RedisConnectionFactory)connectionFactory, this.env, "keyPrefix");
    }
}

