/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.distribute;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.lock.support.DistributedLock;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.springframework.util.ReflectionUtils;

public class DistributeScheduledMethodRunnable
implements Runnable {
    private final Object target;
    private final Method method;
    private final DistributedLock distributedLock;

    public DistributeScheduledMethodRunnable(Object target, Method method, DistributedLock distributedLock) {
        this.target = target;
        this.method = method;
        this.distributedLock = distributedLock;
    }

    public DistributeScheduledMethodRunnable(Object target, String methodName, DistributedLock distributedLock) throws NoSuchMethodException {
        this.target = target;
        this.distributedLock = distributedLock;
        this.method = target.getClass().getMethod(methodName, new Class[0]);
    }

    public Object getTarget() {
        return this.target;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public void run() {
        String className = this.target.getClass().getName();
        String methodName = this.method.getName();
        try {
            ReflectionUtils.makeAccessible((Method)this.method);
            if (Objects.nonNull(this.distributedLock)) {
                boolean successLock = this.distributedLock.tryLock(className + "&&&" + methodName, 5L, TimeUnit.MINUTES);
                if (successLock) {
                    LogUtils.info((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u6210\u529f \u6267\u884c\u5206\u5e03\u5f0f\u4efb\u52a1\u5f00\u59cb", (Object[])new Object[0]);
                    this.method.invoke(this.target, new Object[0]);
                    LogUtils.info((String)"\u6267\u884c\u4efb\u52a1\u57fa\u4e8e\u5206\u5e03\u5f0f\u9501\u6267\u884c\u5b8c\u6210", (Object[])new Object[0]);
                } else {
                    LogUtils.info((String)"\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25", (Object[])new Object[0]);
                }
            }
        }
        catch (InvocationTargetException ex) {
            ReflectionUtils.rethrowRuntimeException((Throwable)ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new UndeclaredThrowableException(ex);
        }
    }

    public String toString() {
        return this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }
}

