/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.other;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.schedule.other.CronTaskRegistrar;
import com.taotao.boot.job.schedule.other.Scheduled2Properties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@AutoConfiguration
@EnableScheduling
@ConditionalOnProperty(prefix="taotao.boot.job.scheduled2", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Scheduled2Properties.class})
public class Scheduled2AutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(Scheduled2AutoConfiguration.class, (String)"taotao-boot-starter-job-schedule", (String[])new String[0]);
    }

    @Bean
    public TaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setPoolSize(6);
        taskScheduler.setRemoveOnCancelPolicy(true);
        taskScheduler.setThreadNamePrefix("TaskSchedulerThreadPool-");
        return taskScheduler;
    }

    @Bean
    public CronTaskRegistrar cronTaskRegistrar(TaskScheduler taskScheduler) {
        return new CronTaskRegistrar(taskScheduler);
    }
}

