/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.other;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class SchedulingRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingRunnable.class);
    private String beanName;
    private String methodName;
    private String params;

    public SchedulingRunnable(String beanName, String methodName) {
        this(beanName, methodName, null);
    }

    public SchedulingRunnable(String beanName, String methodName, String params) {
        this.beanName = beanName;
        this.methodName = methodName;
        this.params = params;
    }

    @Override
    public void run() {
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb\u6267\u884c - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}", new Object[]{this.beanName, this.methodName, this.params});
        long startTime = System.currentTimeMillis();
        try {
            Object target = ContextUtils.getBean((String)this.beanName, (Object[])new Object[0]);
            Method method = !StringUtils.isEmpty((String)this.params) ? target.getClass().getDeclaredMethod(this.methodName, String.class) : target.getClass().getDeclaredMethod(this.methodName, new Class[0]);
            ReflectionUtils.makeAccessible((Method)method);
            if (!StringUtils.isEmpty((String)this.params)) {
                method.invoke(target, this.params);
            } else {
                method.invoke(target, new Object[0]);
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5f02\u5e38 - bean\uff1a%s\uff0c\u65b9\u6cd5\uff1a%s\uff0c\u53c2\u6570\uff1a%s ", this.beanName, this.methodName, this.params), (Throwable)ex);
        }
        long times = System.currentTimeMillis() - startTime;
        logger.info("\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u7ed3\u675f - bean\uff1a{}\uff0c\u65b9\u6cd5\uff1a{}\uff0c\u53c2\u6570\uff1a{}\uff0c\u8017\u65f6\uff1a{} \u6beb\u79d2", new Object[]{this.beanName, this.methodName, this.params, times});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulingRunnable that = (SchedulingRunnable)o;
        if (this.params == null) {
            return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && that.params == null;
        }
        return this.beanName.equals(that.beanName) && this.methodName.equals(that.methodName) && this.params.equals(that.params);
    }

    public int hashCode() {
        if (this.params == null) {
            return Objects.hash(this.beanName, this.methodName);
        }
        return Objects.hash(this.beanName, this.methodName, this.params);
    }
}

