/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.job.schedule.constant.TaskPolicyConstant;
import com.taotao.boot.job.schedule.model.ScheduledTask;
import com.taotao.boot.job.schedule.task.ScheduleTaskRecord;
import com.taotao.boot.job.schedule.task.TaskRunnable;
import com.taotao.boot.job.schedule.utils.CronUtils;
import jakarta.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;

public class TaskManager {
    private final Logger logger = LoggerFactory.getLogger(TaskManager.class);
    private final Map<String, ScheduledFuture<?>> taskScheduledMap = new ConcurrentHashMap();
    private Map<String, ScheduledTask> taskMap = new ConcurrentHashMap<String, ScheduledTask>();
    private static final int MAX_POOL_SIZE = 20;
    @Resource(name="taskScheduler")
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;

    public void initTask() {
        List<ScheduledTask> tasks = ((ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class)).taskList();
        List<ScheduledTask> startTasks = tasks.stream().filter(t -> t.getPolicy() == 2 || t.getSituation() == 1).toList();
        this.logger.info("\u521d\u59cb\u5316\u4efb\u52a1\u5217\u8868\uff1a{}", (Object)startTasks.size());
        int taskSize = startTasks.size();
        int poolSize = taskSize == 0 ? 20 : Math.min(taskSize, 20);
        this.threadPoolTaskScheduler.setPoolSize(poolSize);
        for (ScheduledTask task : startTasks) {
            this.start(task, "sys");
        }
    }

    public void destroyTask() {
        this.logger.info("######## \u7ed3\u675f\u4efb\u52a1 #########");
        this.clear();
    }

    public void start(ScheduledTask task, String runType) {
        String taskId = task.getId();
        Integer policy = task.getPolicy();
        String cron = task.getCronExpression();
        this.logger.info("======== \u521b\u5efa\u4efb\u52a1\uff1a{} ========", (Object)taskId);
        if (this.taskScheduledMap.get(taskId) != null) {
            this.logger.info("\u91cd\u590d\u4efb\u52a1\uff1a" + taskId);
            this.close(taskId);
        }
        if (policy.equals(TaskPolicyConstant.AUTO) || runType.equals("sys")) {
            this.logger.info("======== \u6267\u884c\u4efb\u52a1\uff1a{} ========", (Object)taskId);
            Date nextCurrentTime = CronUtils.nextCurrentTime(task.getCronExpression());
            task.setNextRunTime(nextCurrentTime);
            TaskRunnable taskRunnable = new TaskRunnable(taskId);
            this.taskMap.put(taskId, task);
            ScheduledFuture schedule = this.threadPoolTaskScheduler.schedule((Runnable)taskRunnable, (Trigger)new CronTrigger(cron));
            this.taskScheduledMap.put(taskId, schedule);
            task.setSituation(1);
            ((ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class)).update(task);
        }
    }

    public void close(String taskId) {
        if (this.taskScheduledMap.get(taskId) != null) {
            ScheduledFuture<?> scheduledFuture = this.taskScheduledMap.get(taskId);
            scheduledFuture.cancel(true);
            this.taskScheduledMap.remove(taskId);
            this.taskMap.remove(taskId);
            this.logger.info("\u5173\u95ed\u4efb\u52a1\uff1a" + taskId);
        }
    }

    public void stop(String taskId) {
        if (this.taskScheduledMap.get(taskId) != null) {
            ScheduledFuture<?> scheduledFuture = this.taskScheduledMap.get(taskId);
            scheduledFuture.cancel(true);
            this.taskScheduledMap.remove(taskId);
            this.taskMap.remove(taskId);
            this.logger.info("\u505c\u6b62\u4efb\u52a1\uff1a" + taskId);
            ScheduledTask task = new ScheduledTask();
            task.setId(taskId);
            task.setSituation(2);
            ((ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class)).update(task);
        }
    }

    public void clear() {
        for (Map.Entry<String, ScheduledFuture<?>> entry : this.taskScheduledMap.entrySet()) {
            String taskId = entry.getKey();
            this.stop(taskId);
        }
    }

    public Map<String, ScheduledTask> getTaskMap() {
        return this.taskMap;
    }

    public void setTaskMap(Map<String, ScheduledTask> taskMap) {
        this.taskMap = taskMap;
    }
}

