/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.schedule.model.ScheduledTask;
import com.taotao.boot.job.schedule.task.ScheduleTaskLogRecord;
import com.taotao.boot.job.schedule.task.ScheduleTaskRecord;
import com.taotao.boot.job.schedule.task.TaskManager;
import com.taotao.boot.job.schedule.utils.CronUtils;
import com.taotao.boot.job.schedule.utils.JobInvokeUtil;
import com.taotao.boot.lock.support.DistributedLock;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunnable
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(TaskManager.class);
    private final String id;
    public static final String TASK_LOCK_KEY = "task_lock_key:";
    private boolean checkTime = false;

    public TaskRunnable(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long currentTime = System.currentTimeMillis();
        ScheduledTask currentTask = ((ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class)).selectTaskById(this.id);
        try {
            Date nextRunTime = currentTask.getNextRunTime();
            this.log.info("\u4efb\u52a1\uff1a{}\uff0c\u5f53\u524d\uff1a{}\uff0c\u4e0b\u6b21\uff1a{}", new Object[]{this.id, new Date(), nextRunTime});
            long diffTime = Math.abs(currentTime - nextRunTime.getTime());
            if (diffTime > 200L && this.checkTime) {
                String msg = "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u65f6\u95f4\u8282\u70b9\u9519\u8bef\uff01";
                this.log.error(msg);
                throw new RuntimeException(msg);
            }
            String invokeTarget = currentTask.getInvokeTarget();
            String beanName = JobInvokeUtil.getBeanName(invokeTarget);
            String methodName = JobInvokeUtil.getMethodName(invokeTarget);
            List<Object[]> methodParams = JobInvokeUtil.getMethodParams(invokeTarget);
            methodParams.add(0, new Object[]{this.id, String.class});
            Object bean = ContextUtils.getBean((String)beanName, (Object[])new Object[0]);
            Method method = bean.getClass().getDeclaredMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
            long startTime = System.currentTimeMillis();
            method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
            this.updateTask(currentTask);
            ScheduleTaskLogRecord scheduleTaskLogRecord = (ScheduleTaskLogRecord)ContextUtils.getBean(ScheduleTaskLogRecord.class, (boolean)false);
            if (null != scheduleTaskLogRecord) {
                scheduleTaskLogRecord.recordTaskLog(this.id, startTime, null);
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            this.updateTask(currentTask);
            ScheduleTaskLogRecord scheduleTaskLogRecord = (ScheduleTaskLogRecord)ContextUtils.getBean(ScheduleTaskLogRecord.class, (boolean)false);
            if (null != scheduleTaskLogRecord) {
                scheduleTaskLogRecord.recordTaskLog(this.id, 0L, e);
            }
        }
        finally {
            this.checkTime = true;
        }
    }

    private void updateTask(ScheduledTask currentTask) {
        String taskId = currentTask.getId();
        TaskManager taskManager = (TaskManager)ContextUtils.getBean(TaskManager.class);
        if (taskManager.getTaskMap().get(taskId) != null) {
            String cron = currentTask.getCronExpression();
            String invokeTarget = currentTask.getInvokeTarget();
            Date nextRunTime = currentTask.getNextRunTime();
            Date nextTime = CronUtils.nextCurrentTime(cron);
            ScheduledTask task = new ScheduledTask();
            task.setId(taskId);
            task.setCronExpression(cron);
            task.setInvokeTarget(invokeTarget);
            task.setLastRunTime(nextRunTime);
            task.setNextRunTime(nextTime);
            task.setSituation(1);
            ScheduleTaskRecord scheduleTaskRecord = (ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class);
            if (null != scheduleTaskRecord) {
                scheduleTaskRecord.update(task);
            }
            this.log.info("\u66f4\u65b0\u4efb\u52a1\u6267\u884c\u60c5\u51b5!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDistributedLock() {
        DistributedLock distributedLock = (DistributedLock)ContextUtils.getBean(DistributedLock.class);
        if (distributedLock == null) {
            LogUtils.error((String)"\u5206\u5e03\u5f0f\u9501\u4e3a\u7a7a, \u4e0d\u652f\u6301\u5206\u5e03\u5f0f, \u8bf7\u914d\u7f6etaotao.cloud.lock.type=redis", (Object[])new Object[0]);
            throw new RuntimeException("\u5206\u5e03\u5f0f\u9501\u4e3a\u7a7a");
        }
        String value = UUID.randomUUID().toString();
        long currentTime = System.currentTimeMillis();
        ScheduledTask currentTask = ((ScheduleTaskRecord)ContextUtils.getBean(ScheduleTaskRecord.class)).selectTaskById(this.id);
        try {
            Date nextRunTime = currentTask.getNextRunTime();
            this.log.info("\u4efb\u52a1\uff1a{}\uff0c\u5f53\u524d\uff1a{}\uff0c\u4e0b\u6b21\uff1a{}", new Object[]{this.id, new Date(), nextRunTime});
            long diffTime = Math.abs(currentTime - nextRunTime.getTime());
            String lockKey = TASK_LOCK_KEY + this.id;
            boolean result = diffTime <= 1000L ? distributedLock.tryLock(lockKey, 500L, TimeUnit.MILLISECONDS) : distributedLock.tryLock(lockKey, 1L, TimeUnit.SECONDS);
            if (!result) {
                this.log.info("\u4efb\u52a1:{} \u5df2\u6267\u884c\uff0c\u6682\u505c\u5f53\u524d\u6267\u884c!", (Object)this.id);
            } else {
                if (diffTime > 200L && this.checkTime) {
                    String msg = "\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff0c\u65f6\u95f4\u8282\u70b9\u9519\u8bef\uff01";
                    this.log.error(msg);
                    throw new RuntimeException(msg);
                }
                String invokeTarget = currentTask.getInvokeTarget();
                String beanName = JobInvokeUtil.getBeanName(invokeTarget);
                String methodName = JobInvokeUtil.getMethodName(invokeTarget);
                List<Object[]> methodParams = JobInvokeUtil.getMethodParams(invokeTarget);
                methodParams.add(0, new Object[]{this.id, String.class});
                Object bean = ContextUtils.getBean((String)beanName, (Object[])new Object[0]);
                Method method = bean.getClass().getDeclaredMethod(methodName, JobInvokeUtil.getMethodParamsType(methodParams));
                long startTime = System.currentTimeMillis();
                method.invoke(bean, JobInvokeUtil.getMethodParamsValue(methodParams));
                this.updateTask(currentTask);
                ScheduleTaskLogRecord scheduleTaskLogRecord = (ScheduleTaskLogRecord)ContextUtils.getBean(ScheduleTaskLogRecord.class, (boolean)false);
                if (null != scheduleTaskLogRecord) {
                    scheduleTaskLogRecord.recordTaskLog(this.id, startTime, null);
                }
            }
        }
        catch (Exception e) {
            LogUtils.error((Throwable)e);
            this.updateTask(currentTask);
            ScheduleTaskLogRecord scheduleTaskLogRecord = (ScheduleTaskLogRecord)ContextUtils.getBean(ScheduleTaskLogRecord.class, (boolean)false);
            if (null != scheduleTaskLogRecord) {
                scheduleTaskLogRecord.recordTaskLog(this.id, 0L, e);
            }
        }
        finally {
            this.checkTime = true;
            distributedLock.unlock();
        }
    }
}

