/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.schedule.utils;

import com.taotao.boot.common.utils.log.LogUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.quartz.CronExpression;
import org.quartz.TriggerUtils;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.spi.OperableTrigger;

public class CronUtils {
    private static boolean isValid(String cronExpression) {
        return CronExpression.isValidExpression((String)cronExpression);
    }

    public static Object getNextExecution(String cronExpression, int num, boolean format) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            CronTriggerImpl cronTriggerImpl = new CronTriggerImpl();
            cronTriggerImpl.setCronExpression(cronExpression);
            List dates = TriggerUtils.computeFireTimes((OperableTrigger)cronTriggerImpl, null, (int)num);
            if (!format) {
                return dates;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (Date date : dates) {
                list.add(dateFormat.format(date));
            }
        }
        catch (ParseException e) {
            LogUtils.error((Throwable)e);
        }
        return list;
    }

    public static Date nextCurrentTime(String cron) {
        List execution = (List)CronUtils.getNextExecution(cron, 2, false);
        long timeMillis = System.currentTimeMillis();
        if (Math.abs(timeMillis - ((Date)execution.get(0)).getTime()) > 1000L) {
            return (Date)execution.get(0);
        }
        return (Date)execution.get(1);
    }

    public static Date nextTime(String cron) {
        List execution = (List)CronUtils.getNextExecution(cron, 2, false);
        return (Date)execution.get(1);
    }
}

