/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.xxl.configuration.XxlJobAutoConfiguration;
import com.taotao.boot.job.xxl.timetask.EveryDayExecute;
import com.taotao.boot.job.xxl.timetask.EveryHourExecute;
import com.taotao.boot.job.xxl.timetask.EveryMinuteExecute;
import com.taotao.boot.job.xxl.timetask.TimedTaskJobHandler;
import com.taotao.boot.lock.configuration.LockAutoConfiguration;
import com.taotao.boot.lock.support.DistributedLock;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={XxlJobAutoConfiguration.class}, after={LockAutoConfiguration.class})
public class TimeTaskAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(TimeTaskAutoConfiguration.class, (String)"taotao-boot-starter-job-xxl", (String[])new String[0]);
    }

    @Bean
    @ConditionalOnBean(value={DistributedLock.class})
    public TimedTaskJobHandler timedTaskJobHandler(ObjectProvider<List<EveryMinuteExecute>> everyMinuteExecutes, ObjectProvider<List<EveryHourExecute>> everyHourExecutes, ObjectProvider<List<EveryDayExecute>> everyDayExecutes, DistributedLock distributedLock) {
        return new TimedTaskJobHandler((List)everyMinuteExecutes.getIfAvailable(ArrayList::new), (List)everyHourExecutes.getIfAvailable(ArrayList::new), (List)everyDayExecutes.getIfAvailable(ArrayList::new), distributedLock);
    }
}

