/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.configuration;

import com.taotao.boot.common.constant.CommonConstants;
import com.taotao.boot.common.exception.BusinessException;
import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.xxl.configuration.XxlJobServerList;
import com.taotao.boot.job.xxl.properties.XxlAdminProperties;
import com.taotao.boot.job.xxl.properties.XxlExecutorProperties;
import com.taotao.boot.job.xxl.properties.XxlJobProperties;
import com.taotao.boot.job.xxl.xxljob.aspect.XxlJobMdcInspector;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.job.xxl", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobAutoConfiguration
implements InitializingBean {
    private final XxlJobProperties xxlJobProperties;

    public XxlJobAutoConfiguration(XxlJobProperties xxlJobProperties) {
        this.xxlJobProperties = xxlJobProperties;
    }

    public void afterPropertiesSet() throws Exception {
        LogUtils.started(XxlJobAutoConfiguration.class, (String)"taotao-boot-starter-job-xxl", (String[])new String[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Bean
    public XxlJobSpringExecutor xxlJobSpringExecutor(ObjectProvider<XxlJobServerList> xxlJobServerListProvider, Environment environment) {
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        XxlExecutorProperties executor = this.xxlJobProperties.getExecutor();
        String appName = executor.getAppname();
        if (!StringUtils.hasText((String)appName)) {
            appName = PropertyUtils.getProperty((String)CommonConstants.SPRING_APP_NAME_KEY);
        }
        xxlJobSpringExecutor.setAppname(appName);
        xxlJobSpringExecutor.setAddress(executor.getAddress());
        xxlJobSpringExecutor.setIp(executor.getIp());
        xxlJobSpringExecutor.setPort(executor.getPort().intValue());
        xxlJobSpringExecutor.setAccessToken(executor.getAccessToken());
        xxlJobSpringExecutor.setLogPath(environment.resolvePlaceholders(executor.getLogPath()));
        xxlJobSpringExecutor.setLogRetentionDays(executor.getLogRetentionDays().intValue());
        if (!StringUtils.hasText((String)this.xxlJobProperties.getAdmin().getAddresses())) {
            XxlJobServerList xxlJobServerList = (XxlJobServerList)xxlJobServerListProvider.getIfAvailable();
            if (xxlJobServerList == null) throw new BusinessException("\u8bf7\u914d\u7f6exxljob admin address");
            String serverList = xxlJobServerList.getXxlJobServerList();
            xxlJobSpringExecutor.setAdminAddresses(serverList);
            XxlAdminProperties admin = this.xxlJobProperties.getAdmin();
            admin.setAddresses(serverList);
            this.xxlJobProperties.setAdmin(admin);
            return xxlJobSpringExecutor;
        } else {
            xxlJobSpringExecutor.setAdminAddresses(this.xxlJobProperties.getAdmin().getAddresses());
        }
        return xxlJobSpringExecutor;
    }

    @Bean
    public XxlJobMdcInspector xxlJobMdcInspector() {
        return new XxlJobMdcInspector();
    }
}

