/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.configuration;

import com.taotao.boot.job.xxl.configuration.XxlJobAutoConfiguration;
import com.taotao.boot.job.xxl.configuration.XxlJobServerList;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={XxlJobAutoConfiguration.class})
@ConditionalOnClass(value={DiscoveryClient.class})
@ConditionalOnBean(value={DiscoveryClient.class})
public class XxlJobCloudAutoConfiguration {
    private static final String TAO_TAO_CLOUD_XXL_JOB_ADMIN = "taotao-cloud-xxljob";

    @Bean
    public XxlJobServerList xxlJobServerList(final DiscoveryClient discoveryClient) {
        return new XxlJobServerList(){

            @Override
            public String getXxlJobServerList() {
                return discoveryClient.getServices().stream().filter(s -> s.contains(XxlJobCloudAutoConfiguration.TAO_TAO_CLOUD_XXL_JOB_ADMIN)).flatMap(s -> discoveryClient.getInstances(s).stream()).map(instance -> String.format("http://%s:%s", instance.getHost(), instance.getPort())).collect(Collectors.joining(","));
            }
        };
    }
}

