/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.timetask;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.xxl.timetask.EveryDayExecute;
import com.taotao.boot.job.xxl.timetask.EveryHourExecute;
import com.taotao.boot.job.xxl.timetask.EveryMinuteExecute;
import com.taotao.boot.lock.support.DistributedLock;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TimedTaskJobHandler {
    private final List<EveryMinuteExecute> everyMinuteExecutes;
    private final List<EveryHourExecute> everyHourExecutes;
    private final List<EveryDayExecute> everyDayExecutes;
    private final DistributedLock distributedLock;

    public TimedTaskJobHandler(List<EveryMinuteExecute> everyMinuteExecutes, List<EveryHourExecute> everyHourExecutes, List<EveryDayExecute> everyDayExecutes, DistributedLock distributedLock) {
        this.everyMinuteExecutes = everyMinuteExecutes;
        this.everyHourExecutes = everyHourExecutes;
        this.everyDayExecutes = everyDayExecutes;
        this.distributedLock = distributedLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="everyMinuteExecute")
    public ReturnT<String> everyMinuteExecute(String param) {
        LogUtils.info((String)"\u6bcf\u5206\u949f\u4efb\u52a1\u6267\u884c", (Object[])new Object[0]);
        if (this.everyMinuteExecutes == null || this.everyMinuteExecutes.isEmpty()) {
            return ReturnT.SUCCESS;
        }
        for (EveryMinuteExecute everyMinuteExecute : this.everyMinuteExecutes) {
            try {
                boolean result = this.distributedLock.tryLock("timetask-everyMinuteExecute-" + everyMinuteExecute.getClass().getName(), 30L, TimeUnit.SECONDS);
                if (!result) continue;
                everyMinuteExecute.execute();
            }
            catch (Exception e) {
                LogUtils.error((String)"\u6bcf\u5206\u949f\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e});
                ReturnT returnT = ReturnT.FAIL;
                return returnT;
            }
            finally {
                this.distributedLock.unlock();
            }
        }
        return ReturnT.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="everyHourExecuteJobHandler")
    public ReturnT<String> everyHourExecuteJobHandler(String param) {
        LogUtils.info((String)"\u6bcf\u5c0f\u65f6\u4efb\u52a1\u6267\u884c", (Object[])new Object[0]);
        if (this.everyHourExecutes == null || this.everyHourExecutes.size() == 0) {
            return ReturnT.SUCCESS;
        }
        for (EveryHourExecute everyHourExecute : this.everyHourExecutes) {
            try {
                boolean result = this.distributedLock.tryLock("timetask-everyHourExecute-" + everyHourExecute.getClass().getName(), 30L, TimeUnit.SECONDS);
                if (!result) continue;
                everyHourExecute.execute();
            }
            catch (Exception e) {
                LogUtils.error((String)"\u6bcf\u5c0f\u65f6\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e});
                ReturnT returnT = ReturnT.FAIL;
                return returnT;
            }
            finally {
                this.distributedLock.unlock();
            }
        }
        return ReturnT.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @XxlJob(value="everyDayExecuteJobHandler")
    public ReturnT<String> everyDayExecuteJobHandler(String param) {
        LogUtils.info((String)"\u6bcf\u65e5\u4efb\u52a1\u6267\u884c", (Object[])new Object[0]);
        if (this.everyDayExecutes == null || this.everyDayExecutes.size() == 0) {
            return ReturnT.SUCCESS;
        }
        for (EveryDayExecute everyDayExecute : this.everyDayExecutes) {
            try {
                boolean result = this.distributedLock.tryLock("timetask-everyDayExecute-" + everyDayExecute.getClass().getName(), 30L, TimeUnit.SECONDS);
                if (!result) continue;
                everyDayExecute.execute();
            }
            catch (Exception e) {
                LogUtils.error((String)"\u6bcf\u5929\u4efb\u52a1\u5f02\u5e38", (Object[])new Object[]{e});
                ReturnT returnT = ReturnT.FAIL;
                return returnT;
            }
            finally {
                this.distributedLock.unlock();
            }
        }
        return ReturnT.SUCCESS;
    }
}

