/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.trace;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.job.xxl.trace.XxlJobMethodInterceptor;
import com.xxl.job.core.handler.IJobHandler;
import java.lang.reflect.Modifier;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.AopConfigException;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class XxlJobBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private BeanFactory beanFactory;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean instanceof IJobHandler ? this.wrap(bean) : bean;
    }

    private Object wrap(Object bean) {
        boolean classFinal = Modifier.isFinal(bean.getClass().getModifiers());
        boolean cglibProxy = !classFinal;
        IJobHandler job = (IJobHandler)bean;
        try {
            return this.createProxy(bean, cglibProxy, (Advice)new XxlJobMethodInterceptor<IJobHandler>(job, this.beanFactory));
        }
        catch (AopConfigException ex) {
            if (cglibProxy) {
                LogUtils.warn((String)"Exception occurred while trying to create a proxy, falling back to JDK proxy", (Object[])new Object[]{ex});
                return this.createProxy(bean, false, (Advice)new XxlJobMethodInterceptor<IJobHandler>(job, this.beanFactory));
            }
            throw ex;
        }
    }

    Object createProxy(Object bean, boolean cglibProxy, Advice advice) {
        ProxyFactoryBean factory = new ProxyFactoryBean();
        factory.setProxyTargetClass(cglibProxy);
        factory.addAdvice(advice);
        factory.setTarget(bean);
        return factory.getObject();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

