/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.trace;

import brave.ScopedSpan;
import brave.Tracing;
import com.taotao.boot.common.utils.log.LogUtils;
import com.xxl.job.core.handler.IJobHandler;
import io.micrometer.tracing.SpanNamer;
import io.micrometer.tracing.internal.DefaultSpanNamer;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class XxlJobTraceWrapper
extends IJobHandler {
    private final BeanFactory beanFactory;
    private final IJobHandler delegate;
    private Tracing tracing;
    private SpanNamer spanNamer;

    public XxlJobTraceWrapper(BeanFactory beanFactory, IJobHandler delegate) {
        this.beanFactory = beanFactory;
        this.delegate = delegate;
    }

    public void execute() throws Exception {
        if (this.tracing == null) {
            try {
                this.tracing = (Tracing)this.beanFactory.getBean(Tracing.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                this.delegate.execute();
                return;
            }
        }
        this.doExecute();
    }

    private void doExecute() throws Exception {
        ScopedSpan span = this.tracing.tracer().startScopedSpanWithParent(this.spanNamer().name((Object)this.delegate, "xxl-job"), this.tracing.currentTraceContext().get());
        try {
            this.delegate.execute();
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    private SpanNamer spanNamer() {
        if (this.spanNamer == null) {
            try {
                this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
            }
            catch (NoSuchBeanDefinitionException e) {
                LogUtils.warn((String)"SpanNamer bean not found - will provide a manually created instance", (Object[])new Object[0]);
                return new DefaultSpanNamer();
            }
        }
        return this.spanNamer;
    }
}

