/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.xxljob.aspect;

import com.taotao.boot.common.holder.TraceContextHolder;
import com.taotao.boot.common.support.mdc.MdcAttr;
import com.taotao.boot.common.utils.common.IdGeneratorUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.servlet.TraceUtils;
import com.taotao.boot.job.xxl.xxljob.config.AspectHelper;
import com.taotao.boot.job.xxl.xxljob.config.XxlJobExceptionHandler;
import com.xxl.job.core.context.XxlJobHelper;
import com.xxl.job.core.handler.annotation.XxlJob;
import io.micrometer.tracing.Tracer;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;
import org.springframework.util.StopWatch;

@Aspect
@Order(value=0)
public class XxlJobMdcInspector {
    public static final int SKIP_RESULT_CODE = 202;
    public static final int ORDER = 0;
    public static final String POINTCUT_PATTERN = "execution (public void *.*()) && @annotation(com.xxl.job.core.handler.annotation.XxlJob)";
    public static final String XXLJJOB_POINTCUT_PATTERN = "@annotation(com.xxl.job.core.handler.annotation.XxlJob)";
    private static final AspectHelper.AnnotationHolder<XxlJob> ANNOTATION_HOLDER = new AspectHelper.AnnotationHolder<XxlJob>(){};
    @Autowired(required=false)
    private XxlJobExceptionHandler exceptionHandler;
    @Autowired
    private Tracer tracer;

    @Pointcut(value="@annotation(com.xxl.job.core.handler.annotation.XxlJob)")
    protected void aroundMethod() {
    }

    @Around(value="aroundMethod()")
    public Object inspect(ProceedingJoinPoint joinPoint) throws Throwable {
        MdcAttr mdcAttr = MdcAttr.fromMdc();
        XxlJob job = ANNOTATION_HOLDER.findAnnotationByMethod((JoinPoint)joinPoint);
        Assert.notNull((Object)job, (String)"@XxlJob annotation not found");
        String jobName = job.value();
        long jobId = XxlJobHelper.getJobId();
        String param = XxlJobHelper.getJobParam();
        try {
            Object spanId;
            block15: {
                mdcAttr.putMdc();
                String traceId = IdGeneratorUtils.getIdStr();
                TraceContextHolder.setTraceId((String)traceId);
                TraceUtils.setTtcTraceId((String)traceId);
                try {
                    String tracedId = Objects.requireNonNull(this.tracer.nextSpan()).context().traceId();
                    spanId = Objects.requireNonNull(this.tracer.nextSpan()).context().spanId();
                    TraceUtils.setZipkinTraceId((String)tracedId);
                    TraceUtils.setZipkinSpanId((String)spanId);
                    TraceUtils.setTraceId((String)tracedId);
                    TraceUtils.setSpanId((String)spanId);
                }
                catch (Exception e) {
                    TraceUtils.setZipkinTraceId((String)IdGeneratorUtils.getIdStr());
                    TraceUtils.setZipkinSpanId((String)IdGeneratorUtils.getIdStr());
                    TraceUtils.setTraceId((String)IdGeneratorUtils.getIdStr());
                    TraceUtils.setSpanId((String)IdGeneratorUtils.getIdStr());
                }
                StopWatch sw = null;
                try {
                    LogUtils.info((String)">>>>>>>>>> start xxl-job -> (name: {}, id: {}, param: '{}')", (Object[])new Object[]{jobName, jobId, param});
                    sw = new StopWatch(jobName);
                    sw.start();
                    spanId = joinPoint.proceed();
                    if (sw == null) break block15;
                }
                catch (Exception e) {
                    try {
                        try {
                            Exception cause = null;
                            if (e instanceof InvocationTargetException) {
                                cause = (Exception)e.getCause();
                            }
                            if (cause == null) {
                                cause = e;
                            }
                            LogUtils.error((String)"execute xxl-job exception -> ({}) : {}", (Object[])new Object[]{jobName, cause.getMessage(), cause});
                            throw cause;
                        }
                        catch (Throwable throwable) {
                            if (sw != null) {
                                sw.stop();
                                LogUtils.info((String)"<<<<<<<<<< end xxl-job -> (name: {}, id: {}, costTime: {})", (Object[])new Object[]{jobName, jobId, sw.getTotalTimeMillis()});
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception e2) {
                        this.invokeExceptionHandler(jobName, jobId, param, e2);
                        throw e2;
                    }
                }
                sw.stop();
                LogUtils.info((String)"<<<<<<<<<< end xxl-job -> (name: {}, id: {}, costTime: {})", (Object[])new Object[]{jobName, jobId, sw.getTotalTimeMillis()});
            }
            return spanId;
        }
        finally {
            TraceContextHolder.clear();
            TraceUtils.removeTtcTraceId();
            TraceUtils.removeZipkinTraceId();
            TraceUtils.removeZipkinSpanId();
            TraceUtils.removeTraceId();
            TraceUtils.removeSpanId();
            mdcAttr.removeMdc();
        }
    }

    private void invokeExceptionHandler(String jobName, long jobId, String param, Exception e) {
        try {
            if (this.exceptionHandler == null) {
                return;
            }
            long timestamp = System.currentTimeMillis();
            this.exceptionHandler.handleException(jobName, jobId, param, timestamp, e);
        }
        catch (Exception ex) {
            LogUtils.error((String)"execute xxl-job Invoke-Exception-Handler exception -> ({}) : {}", (Object[])new Object[]{jobName, ex.getMessage(), ex});
        }
    }
}

