/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.job.xxl.xxljob.config;

import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class AspectHelper {
    private static ExpressionParser expressionParser = new SpelExpressionParser();
    private static ConcurrentMap<String, Expression> expressionMap = new ConcurrentHashMap<String, Expression>();

    public static EvaluationContext buildContext(JoinPoint point, Object result) {
        EvaluationContext context = AspectHelper.buildContext(point);
        context.setVariable("result", result);
        return context;
    }

    public static EvaluationContext buildContext(JoinPoint point) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        MethodSignature ms = (MethodSignature)point.getSignature();
        String[] parameterNames = ms.getParameterNames();
        Object[] args = point.getArgs();
        for (int i = 0; i < parameterNames.length; ++i) {
            context.setVariable(parameterNames[i], args[i]);
        }
        return context;
    }

    public static Method getMethod(JoinPoint point) {
        Class<?> targetCls = point.getTarget().getClass();
        MethodSignature ms = (MethodSignature)point.getSignature();
        try {
            return targetCls.getDeclaredMethod(ms.getName(), ms.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class<?> getMethodReturnType(JoinPoint point) {
        Method targetMethod = AspectHelper.getMethod(point);
        if (targetMethod == null) {
            return null;
        }
        return targetMethod.getReturnType();
    }

    public static <T extends Annotation> T getMethodAnnotation(JoinPoint point, Class<T> annotationType) {
        Method targetMethod = AspectHelper.getMethod(point);
        if (targetMethod == null) {
            return null;
        }
        return (T)((Annotation)MergedAnnotations.from((AnnotatedElement)targetMethod, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).get(annotationType).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static Annotation[] getMethodAnnotations(JoinPoint point) {
        Method targetMethod = AspectHelper.getMethod(point);
        if (targetMethod == null) {
            return new Annotation[0];
        }
        return (Annotation[])MergedAnnotations.from((AnnotatedElement)targetMethod, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).stream().map(MergedAnnotation::synthesize).toArray(Annotation[]::new);
    }

    public static <T extends Annotation> T getClassAnnotation(JoinPoint point, Class<T> annotationType) {
        Class<?> targetCls = point.getTarget().getClass();
        return (T)((Annotation)MergedAnnotations.from(targetCls, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).get(annotationType).synthesize(MergedAnnotation::isPresent).orElse(null));
    }

    public static Annotation[] getClassAnnotations(JoinPoint point) {
        Class<?> targetCls = point.getTarget().getClass();
        return (Annotation[])MergedAnnotations.from(targetCls, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.INHERITED_ANNOTATIONS).stream().map(MergedAnnotation::synthesize).toArray(Annotation[]::new);
    }

    public static <T extends Annotation> T getMethodOrClassAnnotation(JoinPoint point, Class<T> annotationType) {
        T annotation = AspectHelper.getMethodAnnotation(point, annotationType);
        if (annotation == null) {
            annotation = AspectHelper.getClassAnnotation(point, annotationType);
        }
        return annotation;
    }

    public static Expression getExpressionByKey(String key) {
        if (expressionMap.containsKey(key)) {
            return (Expression)expressionMap.get(key);
        }
        Expression expression = expressionParser.parseExpression(key);
        expressionMap.putIfAbsent(key, expression);
        return expression;
    }

    public static Map<String, Object> getParameters(JoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        String[] parameterNames = ms.getParameterNames();
        Object[] args = point.getArgs();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(parameterNames.length);
        for (int i = 0; i < parameterNames.length; ++i) {
            paramMap.put(parameterNames[i], args[i]);
        }
        return paramMap;
    }

    public static Object[] getArgs(JoinPoint point) {
        return point.getArgs();
    }

    public static <T> T findFirstArgByType(JoinPoint point, Class<? extends T> clazz) {
        Object[] args;
        for (Object arg : args = AspectHelper.getArgs(point)) {
            if (!clazz.isInstance(arg)) continue;
            return (T)arg;
        }
        return null;
    }

    public static Object findFirstArgByTypes(JoinPoint point, Class<?> ... clazzes) {
        Object[] args;
        for (Object arg : args = AspectHelper.getArgs(point)) {
            for (Class<?> clazz : clazzes) {
                if (!clazz.isInstance(arg)) continue;
                return arg;
            }
        }
        return null;
    }

    public static abstract class AnnotationHolder<T extends Annotation> {
        private Map<Object, SoftReference<T>> map = new ConcurrentHashMap<Object, SoftReference<T>>();

        public T findAnnotation(JoinPoint jp, Function<JoinPoint, Object> funcKey, BiFunction<JoinPoint, Class<T>, T> funcFind) {
            ParameterizedType type;
            Class tClazz;
            Object key = funcKey.apply(jp);
            Annotation val = Optional.ofNullable(this.map.get(key)).map(SoftReference::get).orElse(null);
            if (val == null && (val = (Annotation)funcFind.apply(jp, tClazz = (Class)(type = (ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0])) != null) {
                this.map.put(key, new SoftReference<Annotation>(val));
            }
            return (T)val;
        }

        public T findAnnotationByMethod(JoinPoint jp) {
            return (T)this.findAnnotation(jp, j -> ((MethodSignature)j.getSignature()).getMethod(), AspectHelper::getMethodAnnotation);
        }

        public T findAnnotationByMethodOrClass(JoinPoint jp) {
            return (T)this.findAnnotation(jp, j -> ((MethodSignature)j.getSignature()).getMethod(), AspectHelper::getMethodOrClassAnnotation);
        }

        public T findAnnotationByClass(JoinPoint jp) {
            return (T)this.findAnnotation(jp, j -> j.getTarget().getClass(), AspectHelper::getClassAnnotation);
        }
    }
}

