/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor;

import com.taotao.boot.common.exception.BaseException;
import com.taotao.boot.common.model.Callable;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.thread.ThreadUtils;
import com.taotao.boot.core.properties.AsyncProperties;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.core.support.Ref;
import com.taotao.boot.core.support.ShutdownHooks;
import com.taotao.boot.monitor.properties.MonitorThreadPoolProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.dromara.hutool.core.collection.CollUtil;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class Monitor {
    public static final String TTC_COLLECTOR_ASYNC_EXECUTOR_CALL_KEY = "ttc.async.executor";
    public static final String TTC_COLLECTOR_ASYNC_EXECUTOR_HOOK = "ttc.async.executor.hook";
    public static final String TTC_COLLECTOR_MONITOR_EXECUTOR_CALL_KEY = "ttc.monitor.executor";
    public static final String TTC_COLLECTOR_MONITOR_EXECUTOR_HOOK = "ttc.monitor.executor.hook";
    private ThreadPoolExecutor monitorThreadPoolExecutor;
    private ThreadPoolTaskExecutor asyncThreadPoolExecutor;
    private MonitorThreadPoolProperties monitorThreadPoolProperties;
    private AsyncProperties asyncProperties;
    private Collector collector;

    public Monitor(Collector collector, AsyncProperties asyncProperties, MonitorThreadPoolProperties monitorThreadPoolProperties, ThreadPoolTaskExecutor asyncThreadPoolExecutor, ThreadPoolExecutor monitorThreadPoolExecutor) {
        this.collector = collector;
        this.asyncThreadPoolExecutor = asyncThreadPoolExecutor;
        this.asyncProperties = asyncProperties;
        this.monitorThreadPoolExecutor = monitorThreadPoolExecutor;
        this.monitorThreadPoolProperties = monitorThreadPoolProperties;
        if (Objects.nonNull(this.monitorThreadPoolExecutor)) {
            this.call("ttc.monitor.executor.active.count").set(this.monitorThreadPoolExecutor::getActiveCount);
            this.call("ttc.monitor.executor.core.pool.size").set(this.monitorThreadPoolExecutor::getCorePoolSize);
            this.call("ttc.monitor.executor.pool.size.largest").set(this.monitorThreadPoolExecutor::getLargestPoolSize);
            this.call("ttc.monitor.executor.pool.size.max").set(this.monitorThreadPoolExecutor::getMaximumPoolSize);
            this.call("ttc.monitor.executor.pool.size.count").set(this.monitorThreadPoolExecutor::getPoolSize);
            this.call("ttc.monitor.executor.queue.size").set(() -> this.monitorThreadPoolExecutor.getQueue().size());
            this.call("ttc.monitor.executor.task.count").set(this.monitorThreadPoolExecutor::getTaskCount);
            this.call("ttc.monitor.executor.task.completed").set(this.monitorThreadPoolExecutor::getCompletedTaskCount);
        }
        if (Objects.nonNull(this.asyncThreadPoolExecutor)) {
            this.call("ttc.async.executor.active.count").set(() -> ((ThreadPoolTaskExecutor)this.asyncThreadPoolExecutor).getActiveCount());
            this.call("ttc.async.executor.core.pool.size").set(() -> ((ThreadPoolTaskExecutor)this.asyncThreadPoolExecutor).getCorePoolSize());
            this.call("ttc.async.executor.pool.size.largest").set(() -> this.asyncThreadPoolExecutor.getThreadPoolExecutor().getLargestPoolSize());
            this.call("ttc.async.executor.pool.size.max").set(() -> this.asyncThreadPoolExecutor.getThreadPoolExecutor().getMaximumPoolSize());
            this.call("ttc.async.executor.pool.size.count").set(() -> ((ThreadPoolTaskExecutor)this.asyncThreadPoolExecutor).getPoolSize());
            this.call("ttc.async.executor.queue.size").set(() -> this.asyncThreadPoolExecutor.getThreadPoolExecutor().getQueue().size());
            this.call("ttc.async.executor.task.count").set(() -> this.asyncThreadPoolExecutor.getThreadPoolExecutor().getTaskCount());
            this.call("ttc.async.executor.task.completed").set(() -> this.asyncThreadPoolExecutor.getThreadPoolExecutor().getCompletedTaskCount());
        }
        ShutdownHooks.register((ShutdownHooks.ShutdownHookHandler)new ShutdownHooks.ShutdownHookHandler(){

            public int getOrder() {
                return 1;
            }

            public void runHook() throws Exception {
                super.runHook();
                Monitor.this.monitorShutdown();
                Monitor.this.asyncShutdown();
            }

            public String description() {
                return "\u5173\u95ed\u76d1\u63a7\u73b0\u573a\u6c60\u3001\u5173\u95ed\u6838\u5fc3\u5f02\u6b65\u73b0\u573a\u6c60";
            }
        });
    }

    public Collector.Call call(String key) {
        return this.collector.call(key);
    }

    public Collector.Hook monitorHook() {
        return this.collector.hook(TTC_COLLECTOR_MONITOR_EXECUTOR_HOOK);
    }

    public Collector.Hook asyncHook() {
        return this.collector.hook(TTC_COLLECTOR_ASYNC_EXECUTOR_HOOK);
    }

    private void monitorThreadPoolCheckHealth() {
        if (this.monitorThreadPoolProperties.isCheckHealth() && this.monitorThreadPoolExecutor.getMaximumPoolSize() <= this.monitorThreadPoolExecutor.getPoolSize() && !this.monitorThreadPoolExecutor.getQueue().isEmpty()) {
            LogUtils.warn((String)"\u76d1\u63a7\u7ebf\u7a0b\u6c60\u5df2\u6ee1 \u4efb\u52a1\u5f00\u59cb\u51fa\u73b0\u6392\u961f \u8bf7\u4fee\u6539\u914d\u7f6e [taotao.cloud.core.threadpool.monitor.maximumPoolSize] \u5f53\u524d\u6d3b\u52a8\u7ebf\u7a0b\u6570: {}", (Object[])new Object[]{this.monitorThreadPoolExecutor.getActiveCount()});
        }
    }

    private void coreThreadPoolCheckHealth() {
        if (this.asyncProperties.isCheckHealth() && this.asyncThreadPoolExecutor.getMaxPoolSize() <= this.asyncThreadPoolExecutor.getPoolSize() && !this.asyncThreadPoolExecutor.getThreadPoolExecutor().getQueue().isEmpty()) {
            LogUtils.warn((String)"\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5df2\u6ee1 \u4efb\u52a1\u5f00\u59cb\u51fa\u73b0\u6392\u961f \u8bf7\u4fee\u6539\u914d\u7f6e [taotao.cloud.core.threadpool.async.threadPoolMaxSiz] \u5f53\u524d\u6d3b\u52a8\u7ebf\u7a0b\u6570: {}", (Object[])new Object[]{this.asyncThreadPoolExecutor.getActiveCount()});
        }
    }

    public <T> Future<T> monitorSubmit(String taskName, Callable<T> task) {
        this.monitorThreadPoolCheckHealth();
        return (Future)this.monitorHook().run(taskName, () -> this.monitorThreadPoolExecutor.submit(task));
    }

    public <T> Future<T> asyncSubmit(String taskName, Callable<T> task) {
        if (Objects.isNull(this.asyncThreadPoolExecutor)) {
            LogUtils.warn((String)"\u6838\u5fc3\u7ebf\u7a0b\u6c60\u672a\u521d\u59cb\u5316", (Object[])new Object[0]);
            return null;
        }
        this.coreThreadPoolCheckHealth();
        return (Future)this.asyncHook().run(taskName, () -> this.asyncThreadPoolExecutor.submit(task));
    }

    public void monitorSubmit(String taskName, Runnable task) {
        this.monitorThreadPoolCheckHealth();
        this.monitorHook().run(taskName, () -> this.monitorThreadPoolExecutor.submit(task));
    }

    public Future<?> asyncSubmit(String taskName, Runnable task) {
        if (Objects.isNull(this.asyncThreadPoolExecutor)) {
            LogUtils.warn((String)"\u6838\u5fc3\u7ebf\u7a0b\u6c60\u672a\u521d\u59cb\u5316", (Object[])new Object[0]);
            return null;
        }
        this.coreThreadPoolCheckHealth();
        return (Future)this.asyncHook().run(taskName, () -> this.asyncThreadPoolExecutor.submit(task));
    }

    public boolean monitorIsShutdown() {
        return this.monitorThreadPoolExecutor.isShutdown();
    }

    public boolean coreIsShutdown() {
        if (Objects.isNull(this.asyncThreadPoolExecutor)) {
            LogUtils.warn((String)"\u6838\u5fc3\u7ebf\u7a0b\u6c60\u672a\u521d\u59cb\u5316", (Object[])new Object[0]);
            return true;
        }
        return this.asyncThreadPoolExecutor.getThreadPoolExecutor().isShutdown();
    }

    public void monitorShutdown() {
        ThreadUtils.shutdownThreadPool((ExecutorService)this.monitorThreadPoolExecutor);
    }

    public void asyncShutdown() {
        if (Objects.nonNull(this.asyncThreadPoolExecutor)) {
            this.asyncThreadPoolExecutor.destroy();
        }
    }

    public <T> void monitorParallelFor(String taskName, int parallelCount, List<T> array, Callable.Action1<T> action) {
        this.monitorThreadPoolCheckHealth();
        this.monitorHook().run(taskName, () -> {
            int parallelCount2 = parallelCount;
            if (parallelCount2 > array.size()) {
                parallelCount2 = array.size();
            }
            LinkedList queueTasks = new LinkedList(array);
            while (!queueTasks.isEmpty()) {
                Object task;
                ArrayList runningTasks = new ArrayList(parallelCount2);
                for (int i = 0; i < parallelCount2 && (task = queueTasks.poll()) != null; ++i) {
                    runningTasks.add(task);
                }
                CountDownLatch latch = new CountDownLatch(runningTasks.size());
                ArrayList result = new ArrayList(parallelCount2);
                for (Object e : runningTasks) {
                    Future<?> future = this.monitorThreadPoolExecutor.submit(() -> {
                        try {
                            action.invoke(obj);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    result.add(future);
                }
                try {
                    latch.await();
                }
                catch (InterruptedException exp) {
                    LogUtils.error((Throwable)exp, (String)"parallelFor \u4efb\u52a1\u8ba1\u6570\u5f02\u5e38", (Object[])new Object[0]);
                }
                for (Future future : result) {
                    try {
                        future.get();
                    }
                    catch (Exception exp) {
                        throw new BaseException("parallelFor\u5e76\u884c\u6267\u884c\u51fa\u9519", (Throwable)exp);
                    }
                }
            }
            return 1;
        });
    }

    public <T> void monitorParallelFor2(String taskName, int parallelCount, Collection<T> array, Callable.Action1<T> action) {
        this.monitorThreadPoolCheckHealth();
        this.monitorHook().run(taskName, () -> {
            LinkedList queueTasks;
            int parallelCount2 = parallelCount;
            if (parallelCount2 > array.size()) {
                parallelCount2 = array.size();
            }
            if (!(queueTasks = new LinkedList(array)).isEmpty()) {
                CountDownLatch latch = new CountDownLatch(parallelCount2);
                Object lock = new Object();
                Ref exceptionRef = new Ref(null);
                for (int i = 0; i < parallelCount2; ++i) {
                    this.monitorThreadPoolExecutor.submit(() -> {
                        block6: {
                            while (true) {
                                Object task;
                                Object object = lock;
                                synchronized (object) {
                                    task = queueTasks.poll();
                                }
                                if (task == null || !exceptionRef.isNull()) break;
                                try {
                                    action.invoke(task);
                                }
                                catch (Exception exp) {
                                    latch.countDown();
                                    exceptionRef.setData((Object)exp);
                                    break block6;
                                }
                            }
                            latch.countDown();
                        }
                    });
                }
                try {
                    latch.await();
                }
                catch (InterruptedException exp) {
                    LogUtils.error((Throwable)exp, (String)"parallelFor \u4efb\u52a1\u8ba1\u6570\u5f02\u5e38", (Object[])new Object[0]);
                }
                if (!exceptionRef.isNull()) {
                    throw new BaseException("parallelFor \u5e76\u884c\u6267\u884c\u51fa\u9519", (Throwable)exceptionRef.getData());
                }
            }
            return 1;
        });
    }

    public <T> void parallelFor(String taskName, int parallelCount, Collection<T> taskList, Callable.Action1<T> action) {
        if (parallelCount < 2) {
            for (T t : taskList) {
                action.invoke(t);
            }
        } else {
            this.monitorParallelFor2(taskName, parallelCount, taskList, action);
        }
    }

    public <R, M, D> List<R> batchExecute(int batchExecuteSize, long timeout, List<D> dataList, Function<List<D>, M> middleFunc, Function<M, R> resultFunc) {
        int totalSize = dataList.size();
        int totalPage = totalSize / batchExecuteSize;
        ThreadPoolExecutor pool = new ThreadPoolExecutor(totalPage + 1, totalPage + 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        for (int pageNum = 1; pageNum <= totalPage + 1; ++pageNum) {
            int starNum = (pageNum - 1) * batchExecuteSize;
            int endNum = Math.min(pageNum * batchExecuteSize, totalSize);
            List temList = dataList.subList(starNum, endNum);
            if (!CollUtil.isNotEmpty(temList)) continue;
            Callable<Object> callable = () -> middleFunc.apply(temList);
            Future<Object> future = pool.submit(callable);
            futureList.add(future);
        }
        pool.shutdown();
        List<Object> result = new ArrayList();
        try {
            boolean isFinish = pool.awaitTermination(timeout, TimeUnit.MINUTES);
            if (!isFinish) {
                pool.shutdownNow();
            }
            result = futureList.stream().map(e -> {
                try {
                    return resultFunc.apply(e.get());
                }
                catch (InterruptedException | ExecutionException ex) {
                    throw new RuntimeException(ex);
                }
            }).toList();
        }
        catch (Exception e2) {
            LogUtils.error((Throwable)e2);
        }
        return result;
    }

    public ThreadPoolExecutor getMonitorThreadPoolExecutor() {
        return this.monitorThreadPoolExecutor;
    }

    public void setMonitorThreadPoolExecutor(ThreadPoolExecutor monitorThreadPoolExecutor) {
        this.monitorThreadPoolExecutor = monitorThreadPoolExecutor;
    }

    public ThreadPoolTaskExecutor getAsyncThreadPoolExecutor() {
        return this.asyncThreadPoolExecutor;
    }

    public void setAsyncThreadPoolExecutor(ThreadPoolTaskExecutor asyncThreadPoolExecutor) {
        this.asyncThreadPoolExecutor = asyncThreadPoolExecutor;
    }

    public MonitorThreadPoolProperties getMonitorThreadPoolProperties() {
        return this.monitorThreadPoolProperties;
    }

    public void setMonitorThreadPoolProperties(MonitorThreadPoolProperties monitorThreadPoolProperties) {
        this.monitorThreadPoolProperties = monitorThreadPoolProperties;
    }

    public AsyncProperties getAsyncThreadPoolProperties() {
        return this.asyncProperties;
    }

    public void setAsyncThreadPoolProperties(AsyncProperties asyncProperties) {
        this.asyncProperties = asyncProperties;
    }

    public Collector getCollector() {
        return this.collector;
    }

    public void setCollector(Collector collector) {
        this.collector = collector;
    }
}

