/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.execut;

import com.taotao.boot.monitor.alarm.core.entity.AlarmConfig;
import com.taotao.boot.monitor.alarm.core.entity.AlarmThreshold;
import com.taotao.boot.monitor.alarm.core.execut.SimpleExecuteFactory;
import com.taotao.boot.monitor.alarm.core.execut.spi.NoneExecute;
import com.taotao.boot.monitor.alarm.core.helper.ExecuteHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AlarmExecuteSelector {
    public static ExecuteHelper getDefaultExecute() {
        return ExecuteHelper.DEFAULT_EXECUTE;
    }

    public static List<ExecuteHelper> getExecute(AlarmConfig alarmConfig, int count) {
        if (count < alarmConfig.getMinLimit() || count > alarmConfig.getMaxLimit()) {
            return Collections.singletonList(new ExecuteHelper(SimpleExecuteFactory.getExecute(NoneExecute.NAME), alarmConfig.getUsers()));
        }
        if (!alarmConfig.isAutoIncEmergency()) {
            return Collections.singletonList(new ExecuteHelper(alarmConfig.getExecutor(), alarmConfig.getUsers()));
        }
        if (count < alarmConfig.getAlarmThreshold().get(0).getMin()) {
            return Collections.singletonList(new ExecuteHelper(SimpleExecuteFactory.getExecute(NoneExecute.NAME), alarmConfig.getUsers()));
        }
        ArrayList<ExecuteHelper> list = new ArrayList<ExecuteHelper>();
        for (AlarmThreshold alarmThreshold : alarmConfig.getAlarmThreshold()) {
            if (alarmThreshold.getMin() <= count && count < alarmThreshold.getMax()) {
                list.add(new ExecuteHelper(alarmThreshold.getExecutor(), alarmThreshold.getUsers()));
            }
            if (alarmThreshold.getMin() <= count) continue;
            break;
        }
        return list;
    }
}

