/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.execut;

import com.taotao.boot.monitor.alarm.core.exception.DuplicatedAlarmExecuteDefinedException;
import com.taotao.boot.monitor.alarm.core.execut.api.IExecute;
import com.taotao.boot.monitor.alarm.core.execut.spi.LogExecute;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class SimpleExecuteFactory {
    private static Map<String, IExecute> cacheMap;

    private static void loadAlarmExecute() {
        HashMap<String, IExecute> map = new HashMap<String, IExecute>();
        for (IExecute tmp : ServiceLoader.load(IExecute.class)) {
            if (!map.containsKey(tmp.getName())) {
                map.put(tmp.getName(), tmp);
                continue;
            }
            throw new DuplicatedAlarmExecuteDefinedException("duplicated alarm executor defined!\n>>name:" + tmp.getName() + ">>>clz:" + String.valueOf(tmp.getClass()) + ">>>clz:" + String.valueOf(map.get(tmp.getName())));
        }
        cacheMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IExecute getExecute(String execute) {
        IExecute e = cacheMap.get(execute);
        if (cacheMap != null) return e == null ? cacheMap.get(LogExecute.NAME) : e;
        Class<SimpleExecuteFactory> clazz = SimpleExecuteFactory.class;
        synchronized (SimpleExecuteFactory.class) {
            e = cacheMap.get(execute);
            if (cacheMap != null) return e == null ? cacheMap.get(LogExecute.NAME) : e;
            SimpleExecuteFactory.loadAlarmExecute();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return e == null ? cacheMap.get(LogExecute.NAME) : e;
        }
    }
}

