/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader;

import com.taotao.boot.monitor.alarm.core.exception.NoAlarmLoaderSpecifyException;
import com.taotao.boot.monitor.alarm.core.loader.ConfLoaderProxy;
import com.taotao.boot.monitor.alarm.core.loader.api.IConfLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ConfLoaderFactory {
    private static IConfLoader currentAlarmConfLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IConfLoader loader() {
        if (currentAlarmConfLoader != null) return currentAlarmConfLoader;
        Class<ConfLoaderFactory> clazz = ConfLoaderFactory.class;
        synchronized (ConfLoaderFactory.class) {
            if (currentAlarmConfLoader != null) return currentAlarmConfLoader;
            ConfLoaderFactory.initConfLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentAlarmConfLoader;
        }
    }

    private static void initConfLoader() {
        Iterator<IConfLoader> iterator = ServiceLoader.load(IConfLoader.class).iterator();
        ArrayList<IConfLoader> list = new ArrayList<IConfLoader>();
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        list.sort(Comparator.comparingInt(IConfLoader::order));
        ArrayList<IConfLoader> ans = new ArrayList<IConfLoader>(list.size());
        for (IConfLoader iConfLoader : list) {
            if (!iConfLoader.load()) continue;
            ans.add(iConfLoader);
        }
        if (ans.isEmpty()) {
            throw new NoAlarmLoaderSpecifyException("no special alarmConfLoader selected!");
        }
        currentAlarmConfLoader = new ConfLoaderProxy(ans);
    }
}

