/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader.helper;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.alarm.core.entity.AlarmConfig;
import java.io.File;
import java.io.FileFilter;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class PropertiesConfListenerHelper {
    public static boolean registerConfChangeListener(File file, Function<File, Map<String, AlarmConfig>> func) {
        try {
            long interval = TimeUnit.SECONDS.toMillis(5L);
            File dir = file.getParentFile();
            FileAlterationObserver observer = new FileAlterationObserver(dir, (FileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), FileFilterUtils.nameFileFilter((String)file.getName())}));
            observer.addListener((FileAlterationListener)new MyFileListener(func));
            FileAlterationMonitor monitor = new FileAlterationMonitor(interval, new FileAlterationObserver[]{observer});
            monitor.start();
            return true;
        }
        catch (Exception e) {
            LogUtils.error((String)"register properties change listener error! e:{}", (Object[])new Object[]{e});
            return false;
        }
    }

    static final class MyFileListener
    extends FileAlterationListenerAdaptor {
        private Function<File, Map<String, AlarmConfig>> func;

        public MyFileListener(Function<File, Map<String, AlarmConfig>> func) {
            this.func = func;
        }

        public void onFileChange(File file) {
            LogUtils.info((String)("change >>> " + System.currentTimeMillis()), (Object[])new Object[0]);
            Map<String, AlarmConfig> ans = this.func.apply(file);
            LogUtils.warn((String)"PropertiesConfig changed! reload ans: {}", (Object[])new Object[]{ans});
        }
    }
}

