/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader.helper;

import com.taotao.boot.monitor.alarm.core.exception.RegisterInfoIllegalException;
import com.taotao.boot.monitor.alarm.core.loader.entity.RegisterInfo;
import com.taotao.boot.monitor.alarm.core.loader.util.PropertiesUtil;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterInfoLoaderHelper {
    private static final Logger log = LoggerFactory.getLogger(RegisterInfoLoaderHelper.class);
    private static final String DEFAULT_CONF_NAME = "alarm.properties";
    private static volatile RegisterInfo instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RegisterInfo load() {
        if (instance != null) return instance;
        Class<RegisterInfoLoaderHelper> clazz = RegisterInfoLoaderHelper.class;
        synchronized (RegisterInfoLoaderHelper.class) {
            if (instance != null) return instance;
            try {
                Properties properties = PropertiesUtil.read(DEFAULT_CONF_NAME);
                RegisterInfo info = new RegisterInfo();
                PropertiesUtil.copy(properties, info);
                RegisterInfoLoaderHelper.checkRegisterInfo(info);
                instance = info;
            }
            catch (RegisterInfoIllegalException ex) {
                log.error("illegal register info: {}", (Throwable)ex);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            catch (Exception e) {
                log.error("load register info error: {}", (Throwable)e);
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            return instance;
        }
    }

    private static void checkRegisterInfo(RegisterInfo registerInfo) {
        if (StringUtils.isBlank((CharSequence)registerInfo.getAlarmConfPath())) {
            throw new RegisterInfoIllegalException("alarmConfPath should not be null or empty!");
        }
        if (StringUtils.isBlank((CharSequence)registerInfo.getAppName())) {
            throw new RegisterInfoIllegalException("appName should not be null or empty!");
        }
        if (StringUtils.isBlank((CharSequence)registerInfo.getDefaultAlarmUsers())) {
            throw new RegisterInfoIllegalException("defaultAlarmUser should not be null or empty!");
        }
        if (registerInfo.getMaxAlarmType() == null) {
            registerInfo.setMaxAlarmType(1000);
        }
    }
}

