/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader.parse;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.taotao.boot.monitor.alarm.core.entity.AlarmConfig;
import com.taotao.boot.monitor.alarm.core.entity.AlarmThreshold;
import com.taotao.boot.monitor.alarm.core.entity.BasicAlarmConfig;
import com.taotao.boot.monitor.alarm.core.entity.BasicAlarmThreshold;
import com.taotao.boot.monitor.alarm.core.execut.SimpleExecuteFactory;
import com.taotao.boot.monitor.alarm.core.execut.spi.LogExecute;
import com.taotao.boot.monitor.alarm.core.execut.spi.NoneExecute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmConfParse {
    public static final String DEFAULT_ALARM_KEY = "default";
    private static final Logger logger = LoggerFactory.getLogger(AlarmConfParse.class);
    private static final BasicAlarmConfig DEFAULT_ALARM_CONFIG = AlarmConfParse.getDefaultAlarmConfig();
    private static final TypeReference<Map<String, BasicAlarmConfig>> typeReference = new TypeReference<Map<String, BasicAlarmConfig>>(){};
    private static List<String> currentUsers;

    public static Map<String, AlarmConfig> parseConfig(String configs, List<String> defaultUsers) {
        currentUsers = defaultUsers;
        Map<String, BasicAlarmConfig> map = AlarmConfParse.parseStrConfig2Map(configs);
        if (map == null) {
            return null;
        }
        ConcurrentHashMap<String, AlarmConfig> backConfigMap = new ConcurrentHashMap<String, AlarmConfig>();
        for (Map.Entry<String, BasicAlarmConfig> entry : map.entrySet()) {
            AlarmConfig temp = AlarmConfParse.parse2BizConfig(entry.getValue());
            if (temp == null) continue;
            for (String key : StringUtils.split((String)entry.getKey(), (String)",")) {
                backConfigMap.put(key, temp);
            }
        }
        return backConfigMap;
    }

    private static Map<String, BasicAlarmConfig> parseStrConfig2Map(String configs) {
        Map<String, BasicAlarmConfig> map = null;
        if (configs != null) {
            try {
                map = (Map)JSON.parseObject((String)configs, typeReference, (JSONReader.Feature[])new JSONReader.Feature[0]);
            }
            catch (Exception e) {
                logger.error("ConfigWrapper.parseStrConfig2Map() init config error! configs: {}, e:{}", (Object)configs, (Object)e);
                return null;
            }
        }
        if (map == null) {
            map = new HashMap<String, BasicAlarmConfig>(1);
        }
        if (!map.containsKey(DEFAULT_ALARM_KEY)) {
            map.put(DEFAULT_ALARM_KEY, DEFAULT_ALARM_CONFIG);
        }
        return map;
    }

    private static AlarmConfig parse2BizConfig(BasicAlarmConfig basicAlarmConfig) {
        AlarmThreshold tmpAlarmThreshold;
        if (basicAlarmConfig.getUsers() == null || basicAlarmConfig.getUsers().isEmpty()) {
            return null;
        }
        AlarmConfig alarmConfig = new AlarmConfig();
        alarmConfig.setExecutor(SimpleExecuteFactory.getExecute(basicAlarmConfig.getLevel()));
        alarmConfig.setAutoIncEmergency(basicAlarmConfig.isAutoIncEmergency());
        alarmConfig.setUsers(basicAlarmConfig.getUsers());
        alarmConfig.setMaxLimit(basicAlarmConfig.getMax() == null ? 30 : basicAlarmConfig.getMax());
        alarmConfig.setMinLimit(basicAlarmConfig.getMin() == null ? 0 : basicAlarmConfig.getMin());
        List<BasicAlarmThreshold> basicAlarmThresholdList = basicAlarmConfig.getThreshold();
        if (basicAlarmThresholdList == null) {
            basicAlarmThresholdList = Collections.emptyList();
        }
        basicAlarmThresholdList.sort(Comparator.comparingInt(BasicAlarmThreshold::getThreshold));
        ArrayList<AlarmThreshold> alarmThresholdList = new ArrayList<AlarmThreshold>(basicAlarmThresholdList.size() + 2);
        boolean containDefaultExecute = false;
        for (int i = 0; i < basicAlarmThresholdList.size(); ++i) {
            BasicAlarmThreshold tmpBasicAlarmThreshold = basicAlarmThresholdList.get(i);
            tmpAlarmThreshold = new AlarmThreshold();
            tmpAlarmThreshold.setExecutor(SimpleExecuteFactory.getExecute(tmpBasicAlarmThreshold.getLevel()));
            tmpAlarmThreshold.setUsers(tmpBasicAlarmThreshold.getUsers());
            tmpAlarmThreshold.setMin(tmpBasicAlarmThreshold.getThreshold());
            if (tmpBasicAlarmThreshold.getMax() == null || tmpBasicAlarmThreshold.getMax() <= tmpBasicAlarmThreshold.getThreshold()) {
                if (i == basicAlarmThresholdList.size() - 1) {
                    tmpAlarmThreshold.setMax(alarmConfig.getMaxLimit());
                } else {
                    tmpAlarmThreshold.setMax(basicAlarmThresholdList.get(i + 1).getThreshold());
                }
            } else {
                tmpAlarmThreshold.setMax(tmpBasicAlarmThreshold.getMax());
            }
            if (!containDefaultExecute) {
                containDefaultExecute = tmpBasicAlarmThreshold.getLevel().equals(basicAlarmConfig.getLevel());
            }
            alarmThresholdList.add(tmpAlarmThreshold);
        }
        int thresholdSize = alarmThresholdList.size();
        if (thresholdSize == 0) {
            tmpAlarmThreshold = new AlarmThreshold();
            tmpAlarmThreshold.setExecutor(alarmConfig.getExecutor());
            tmpAlarmThreshold.setUsers(alarmConfig.getUsers());
            tmpAlarmThreshold.setMin(alarmConfig.getMinLimit());
            tmpAlarmThreshold.setMax(alarmConfig.getMaxLimit());
            alarmThresholdList.add(tmpAlarmThreshold);
        } else if (!containDefaultExecute) {
            tmpAlarmThreshold = new AlarmThreshold();
            tmpAlarmThreshold.setExecutor(alarmConfig.getExecutor());
            tmpAlarmThreshold.setUsers(alarmConfig.getUsers());
            tmpAlarmThreshold.setMin(alarmConfig.getMinLimit());
            tmpAlarmThreshold.setMax(((AlarmThreshold)alarmThresholdList.get(0)).getMin());
            alarmThresholdList.add(0, tmpAlarmThreshold);
            if (((AlarmThreshold)alarmThresholdList.get(thresholdSize)).getMax() < alarmConfig.getMaxLimit()) {
                tmpAlarmThreshold = new AlarmThreshold();
                tmpAlarmThreshold.setExecutor(alarmConfig.getExecutor());
                tmpAlarmThreshold.setUsers(alarmConfig.getUsers());
                tmpAlarmThreshold.setMin(((AlarmThreshold)alarmThresholdList.get(thresholdSize)).getMax());
                tmpAlarmThreshold.setMax(alarmConfig.getMaxLimit());
                alarmThresholdList.add(tmpAlarmThreshold);
            }
        }
        alarmConfig.setAlarmThreshold(alarmThresholdList);
        return alarmConfig;
    }

    private static BasicAlarmConfig getDefaultAlarmConfig() {
        BasicAlarmConfig defaultConfig = new BasicAlarmConfig();
        defaultConfig.setMin(5);
        defaultConfig.setMax(30);
        defaultConfig.setUsers(currentUsers);
        defaultConfig.setLevel(NoneExecute.NAME);
        defaultConfig.setAutoIncEmergency(true);
        BasicAlarmThreshold logThreshold = new BasicAlarmThreshold();
        logThreshold.setThreshold(10);
        logThreshold.setLevel(LogExecute.NAME);
        logThreshold.setUsers(currentUsers);
        defaultConfig.setThreshold(Collections.singletonList(logThreshold));
        return defaultConfig;
    }
}

