/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader.spi;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.alarm.core.entity.AlarmConfig;
import com.taotao.boot.monitor.alarm.core.loader.api.IConfLoader;
import com.taotao.boot.monitor.alarm.core.loader.entity.RegisterInfo;
import com.taotao.boot.monitor.alarm.core.loader.helper.PropertiesConfListenerHelper;
import com.taotao.boot.monitor.alarm.core.loader.helper.RegisterInfoLoaderHelper;
import com.taotao.boot.monitor.alarm.core.loader.parse.AlarmConfParse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class PropertiesConfLoader
implements IConfLoader {
    private RegisterInfo registerInfo;
    private Map<String, AlarmConfig> cacheMap;
    private AlarmConfig defaultAlarmConfig;

    @Override
    public boolean load() {
        File file;
        this.registerInfo = RegisterInfoLoaderHelper.load();
        if (this.registerInfo == null) {
            return false;
        }
        String path = this.registerInfo.getAlarmConfPath();
        if (path.startsWith("/")) {
            file = new File(path);
        } else {
            URL url = this.getClass().getClassLoader().getResource(path);
            file = new File(url.getFile());
        }
        Map<String, AlarmConfig> tmp = this.init(file);
        boolean ans = tmp != null;
        boolean bl = ans = ans && PropertiesConfListenerHelper.registerConfChangeListener(file, this::init);
        if (ans) {
            LogUtils.info((String)"PropertiesConfLoader registerConfChangeListener success!", (Object[])new Object[0]);
        }
        return ans;
    }

    private Map<String, AlarmConfig> init(File file) {
        Map<String, AlarmConfig> tmp;
        try {
            List list = IOUtils.readLines((InputStream)new FileInputStream(file), (String)"utf-8");
            String config = Joiner.on((String)"").join((Iterable)list);
            tmp = AlarmConfParse.parseConfig(config, Splitter.on((String)",").splitToList((CharSequence)this.registerInfo.getDefaultAlarmUsers()));
        }
        catch (IOException e) {
            LogUtils.error((String)"load config into cacheMap error! e: {}", (Object[])new Object[]{e});
            return null;
        }
        if (tmp != null) {
            this.cacheMap = tmp;
            this.defaultAlarmConfig = this.cacheMap.get("default");
        }
        return tmp;
    }

    @Override
    public RegisterInfo getRegisterInfo() {
        return this.registerInfo;
    }

    @Override
    public boolean alarmEnable(String alarmKey) {
        return true;
    }

    @Override
    public boolean containAlarmConfig(String alarmKey) {
        return this.cacheMap.containsKey(alarmKey);
    }

    @Override
    public AlarmConfig getAlarmConfigOrDefault(String alarmKey) {
        return this.cacheMap.getOrDefault(alarmKey, this.defaultAlarmConfig);
    }
}

