/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.core.loader.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class PropertiesUtil {
    public static Properties read(String fileName) throws IOException {
        try (InputStream inputStream = PropertiesUtil.class.getClassLoader().getResourceAsStream(fileName);){
            Properties pro = new Properties();
            pro.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            Properties properties = pro;
            return properties;
        }
    }

    public static void copy(Properties source, Object dest) throws IllegalAccessException {
        Field[] fields;
        for (Field f : fields = dest.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers())) continue;
            f.setAccessible(true);
            f.set(dest, PropertiesUtil.parseObj(source.getProperty(f.getName()), f.getType()));
        }
    }

    private static <T> T parseObj(String obj, Class<T> clz) {
        return ParseFuncEnum.getFunc(clz).apply(obj);
    }

    public static enum ParseFuncEnum {
        INT_PARSE((List)List.of(Integer.TYPE, Integer.class)){

            public Function<String, Integer> getFunc() {
                return Integer::valueOf;
            }
        }
        ,
        LONG_PARSE((List)List.of(Long.TYPE, Long.class)){

            public Function<String, Long> getFunc() {
                return Long::valueOf;
            }
        }
        ,
        BOOLEAN_PARSE((List)List.of(Boolean.TYPE, Boolean.class)){

            public Function<String, Boolean> getFunc() {
                return Boolean::valueOf;
            }
        }
        ,
        FLOAT_PARSE((List)List.of(Float.TYPE, Float.class)){

            public Function<String, Float> getFunc() {
                return Float::valueOf;
            }
        }
        ,
        DOUBLE_PARSE((List)List.of(Double.TYPE, Double.class)){

            public Function<String, Double> getFunc() {
                return Double::valueOf;
            }
        }
        ,
        SHORT_PARSE((List)List.of(Short.TYPE, Short.class)){

            public Function<String, Short> getFunc() {
                return Short::valueOf;
            }
        }
        ,
        BYTE_PARSE((List)List.of(Byte.TYPE, Byte.class)){

            public Function<String, Byte> getFunc() {
                return Byte::valueOf;
            }
        }
        ,
        CHAR_PARSE((List)List.of(Character.TYPE, Character.class)){

            public Function<String, Character> getFunc() {
                return s -> Character.valueOf(s.charAt(0));
            }
        }
        ,
        STRING_PARSE((List)List.of(String.class)){

            public Function<String, String> getFunc() {
                return s -> s;
            }
        };

        private final List<Class<?>> clzList;
        private static Map<Class<?>, ParseFuncEnum> map;

        public abstract <T> Function<String, T> getFunc();

        private ParseFuncEnum(List<Class<?>> clz) {
            this.clzList = clz;
        }

        public static <T> Function<String, T> getFunc(Class<T> clz) {
            return map.get(clz).getFunc();
        }

        static {
            map = new ConcurrentHashMap(20);
            for (ParseFuncEnum enu : ParseFuncEnum.values()) {
                for (Class<?> clz : enu.clzList) {
                    map.put(clz, enu);
                }
            }
        }
    }
}

