/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.plugin.dingding.util;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DingdingPublisher {
    private static final String TEMPLATE = "title:\t%s\n\ncontent:\t%s";
    private static final Logger logger = LoggerFactory.getLogger(DingdingPublisher.class);
    private static final String DING_TALK_URL = "https://oapi.dingtalk.com/robot/send?access_token=";
    private static final MediaType JSON;
    private static OkHttpClient okHttpClient;

    public static void sendMessage(String title, String content, String token) {
        String msg = String.format(TEMPLATE, title, content);
        try {
            DingdingPublisher.doPost(msg, token);
        }
        catch (Exception e) {
            logger.error("failed to publish msg: {} to DingDing! {}", (Object)msg, (Object)e);
        }
    }

    public static String doPost(String msg, String token) throws IOException {
        RequestBody body = RequestBody.create((String)DingdingPublisher.buildTextMsgBody(msg), (MediaType)JSON);
        try (Response response = okHttpClient.newCall(new Request.Builder().url(DING_TALK_URL + token).post(body).build()).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static String buildTextMsgBody(String content) {
        JSONObject msg = new JSONObject();
        msg.put((Object)"msgtype", (Object)"text");
        JSONObject text = new JSONObject();
        text.put((Object)"content", (Object)content);
        msg.put((Object)"text", (Object)text);
        return msg.toJSONString(new JSONWriter.Feature[0]);
    }

    static {
        okHttpClient = new OkHttpClient();
        JSON = MediaType.get((String)"application/json; charset=utf-8");
    }
}

