/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.alarm.plugin.feishu.util;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeishuPublisher {
    private static final String TEMPLATE = "title:\t%s\n\ncontent:\t%s";
    private static final Logger logger = LoggerFactory.getLogger(FeishuPublisher.class);
    private static final String FEISHU_URL = "https://open.feishu.cn/open-apis/bot/hook/";
    private static final MediaType JSON;
    private static OkHttpClient okHttpClient;

    public static void sendMessage(String title, String content, String token) {
        try {
            FeishuPublisher.doPost(title, content, token);
        }
        catch (Exception e) {
            logger.error("failed to publish msg: {} to DingDing! {}", (Object)content, (Object)e);
        }
    }

    public static String doPost(String title, String content, String token) throws IOException {
        RequestBody body = RequestBody.create((String)FeishuPublisher.buildTextMsgBody(title, content), (MediaType)JSON);
        try (Response response = okHttpClient.newCall(new Request.Builder().url(FEISHU_URL + token).post(body).build()).execute();){
            String string = response.body().string();
            return string;
        }
    }

    private static String buildTextMsgBody(String title, String content) {
        JSONObject msg = new JSONObject(4);
        msg.put((Object)"title", (Object)title);
        msg.put((Object)"text", (Object)content);
        return msg.toJSONString(new JSONWriter.Feature[0]);
    }

    static {
        okHttpClient = new OkHttpClient();
        JSON = MediaType.get((String)"application/json; charset=utf-8");
    }
}

