/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.enums.WarnTypeEnum;
import com.taotao.boot.monitor.model.Message;
import com.taotao.boot.monitor.model.Report;
import com.taotao.boot.monitor.warn.WarnProvider;

public abstract class AbstractCollectTask
implements AutoCloseable {
    protected long byteToMb = 0x100000L;
    protected volatile boolean start = true;
    private CollectInfo lastCollectInfo = null;
    protected long lastRunTime = System.currentTimeMillis();

    public abstract int getTimeSpan();

    public abstract boolean getEnabled();

    public abstract String getDesc();

    public abstract String getName();

    public Report getReport() {
        if (this.start) {
            long time = System.currentTimeMillis() - this.lastRunTime;
            if (this.getTimeSpan() > 0 && time > (long)this.getTimeSpan() * 1000L) {
                this.lastRunTime = System.currentTimeMillis();
                this.lastCollectInfo = this.getData();
            }
            if (this.lastCollectInfo == null) {
                return null;
            }
            return new Report(this.lastCollectInfo);
        }
        return null;
    }

    public static void notifyMessage(WarnTypeEnum type, String subject, String content) {
        LogUtils.warn((String)("[warn]" + subject + "\r\n" + content), (Object[])new Object[0]);
        WarnProvider warnProvider = (WarnProvider)ContextUtils.getBean(WarnProvider.class, (boolean)false);
        if (warnProvider != null) {
            Message message = new Message();
            message.setWarnType(type);
            message.setTitle(subject);
            message.setContent(content);
            if (type == WarnTypeEnum.ERROR) {
                warnProvider.notifyNow(message);
            } else {
                warnProvider.notify(message);
            }
        }
    }

    public static void notifyMessage(Message message) {
        WarnProvider warnProvider = (WarnProvider)ContextUtils.getBean(WarnProvider.class, (boolean)false);
        if (warnProvider != null) {
            if (message.getWarnType() == WarnTypeEnum.ERROR) {
                warnProvider.notifyNow(message);
            } else {
                warnProvider.notify(message);
            }
        }
    }

    protected CollectInfo getData() {
        return null;
    }

    @Override
    public void close() throws Exception {
        this.start = false;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }
}

