/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.servlet.ResponseUtils;
import com.taotao.boot.monitor.collect.HealthCheckProvider;
import com.taotao.boot.monitor.model.Report;
import com.taotao.boot.monitor.properties.DumpProperties;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import org.springframework.util.StringUtils;

public class HealthReportFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String contextPath = StringUtils.trimTrailingCharacter((String)request.getContextPath(), (char)'/');
        String uri = request.getRequestURI();
        HealthCheckProvider healthProvider = (HealthCheckProvider)ContextUtils.getBean(HealthCheckProvider.class, (boolean)true);
        DumpProperties dumpProperties = (DumpProperties)ContextUtils.getBean(DumpProperties.class, (boolean)true);
        if (Objects.nonNull(healthProvider) && Objects.nonNull(dumpProperties) && uri.startsWith(contextPath + "/health/report")) {
            try {
                boolean isAnalyse = !"false".equalsIgnoreCase(request.getParameter("isAnalyse"));
                Report report = healthProvider.getReport(isAnalyse);
                if (request.getContentType() != null && request.getContentType().contains("json")) {
                    response.setHeader("Content-type", "application/json;charset=UTF-8");
                    String html = report.toJson();
                    ResponseUtils.success((HttpServletResponse)response, (Object)html);
                    return;
                }
                response.setHeader("Content-type", "text/html;charset=UTF-8");
                Object html = report.toHtml().replace("\r\n", "<br/>").replace("\n", "<br/>").replace("/n", "\n").replace("/r", "\r");
                if (dumpProperties.isEnabled()) {
                    html = "dump\u4fe1\u606f:<a href='/health/dump/'>\u67e5\u770b</a><br/>" + (String)html;
                }
                response.setCharacterEncoding("UTF-8");
                response.getWriter().append((CharSequence)html);
                response.getWriter().flush();
                response.getWriter().close();
            }
            catch (Exception e) {
                LogUtils.error((Throwable)e, (String)"taotao-boot-starter-monitor", (Object[])new Object[]{"/health/report\u6253\u5f00\u51fa\u9519"});
                response.getWriter().close();
            }
        }
    }

    public void destroy() {
    }
}

