/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.properties.AsyncProperties;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.Objects;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class AsyncThreadPoolCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.executor.async";
    private final CollectTaskProperties properties;
    private final ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public AsyncThreadPoolCollectTask(CollectTaskProperties properties, ThreadPoolTaskExecutor threadPoolTaskExecutor) {
        this.properties = properties;
        this.threadPoolTaskExecutor = threadPoolTaskExecutor;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getAsyncThreadTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.getAsyncThreadEnabled();
    }

    @Override
    protected CollectInfo getData() {
        block3: {
            try {
                Collector collector = Collector.getCollector();
                AsyncProperties asyncProperties = (AsyncProperties)ContextUtils.getBean(AsyncProperties.class, (boolean)true);
                if (Objects.nonNull(collector) && Objects.nonNull(asyncProperties)) {
                    String asyncThreadName = asyncProperties.getThreadNamePrefix().replace("-", ".");
                    AsyncExecutorCollectInfo info = new AsyncExecutorCollectInfo();
                    info.asyncExecutorActiveCount = (Integer)collector.call(asyncThreadName + ".active.count").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getActiveCount()).run();
                    info.asyncExecutorCorePoolSize = (Integer)collector.call(asyncThreadName + ".core.pool.size").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getCorePoolSize()).run();
                    info.asyncExecutorPoolSizeLargest = (Integer)collector.call(asyncThreadName + ".pool.size.largest").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getPoolSize()).run();
                    info.asyncExecutorPoolSizeMax = (Integer)collector.call(asyncThreadName + ".pool.size.max").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getMaxPoolSize()).run();
                    info.asyncExecutorPoolSizeCount = (Integer)collector.call(asyncThreadName + ".pool.size.count").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getCorePoolSize()).run();
                    info.asyncExecutorQueueSize = (Integer)collector.call(asyncThreadName + ".queue.size").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getQueueSize()).run();
                    info.asyncExecutorTaskCount = Long.valueOf(String.valueOf(collector.call(asyncThreadName + ".task.count").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getActiveCount()).run()));
                    info.asyncExecutorTaskCompleted = Long.valueOf(String.valueOf(collector.call(asyncThreadName + ".task.completed").set(() -> ((ThreadPoolTaskExecutor)this.threadPoolTaskExecutor).getActiveCount()).run()));
                    Collector.Hook hook = collector.hook(asyncThreadName + ".hook");
                    info.asyncExecutorTaskHookCurrent = hook.getCurrent();
                    info.asyncExecutorTaskHookError = hook.getLastErrorPerSecond();
                    info.asyncExecutorTaskHookSuccess = hook.getLastSuccessPerSecond();
                    info.asyncExecutorTaskHookList = hook.getMaxTimeSpanList().toText();
                    info.asyncExecutorTaskHookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
                    return info;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block3;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    private static class AsyncExecutorCollectInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.executor.async.active.count", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u6d3b\u52a8\u7ebf\u7a0b\u6570")
        private Integer asyncExecutorActiveCount = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.core.pool.size", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u6838\u5fc3\u7ebf\u7a0b\u6570")
        private Integer asyncExecutorCorePoolSize = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.pool.size.largest", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5386\u53f2\u6700\u5927\u7ebf\u7a0b\u6570")
        private Integer asyncExecutorPoolSizeLargest = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.pool.size.max", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u6700\u5927\u7ebf\u7a0b\u6570")
        private Integer asyncExecutorPoolSizeMax = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.pool.size.count", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5f53\u524d\u7ebf\u7a0b\u6570")
        private Integer asyncExecutorPoolSizeCount = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.queue.size", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5f53\u524d\u6392\u961f\u7b49\u5f85\u4efb\u52a1\u6570")
        private Integer asyncExecutorQueueSize = 0;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.count", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5386\u53f2\u4efb\u52a1\u6570")
        private Long asyncExecutorTaskCount = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.completed", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u5df2\u5b8c\u6210\u4efb\u52a1\u6570")
        private Long asyncExecutorTaskCompleted = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.hook.error", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long asyncExecutorTaskHookError = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.hook.success", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long asyncExecutorTaskHookSuccess = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.hook.current", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long asyncExecutorTaskHookCurrent = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.async.task.hook.list.detail", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String asyncExecutorTaskHookList = "";
        @FieldReport(name="ttc.monitor.collect.executor.async.task.hook.list.minute.detail", desc="\u5f02\u6b65\u6838\u5fc3\u7ebf\u7a0b\u6c60\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String asyncExecutorTaskHookListPerMinute = "";

        private AsyncExecutorCollectInfo() {
        }
    }
}

