/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.lang.ObjectUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.lang.reflect.Field;
import javax.sql.DataSource;

public class DataSourceCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.datasource";
    private final CollectTaskProperties properties;
    private final boolean classExist;

    public DataSourceCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
        this.classExist = ClassUtils.isExist((String)"javax.sql.DataSource");
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getDatasourcTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isDatasourceEnabled() && this.classExist;
    }

    @Override
    protected CollectInfo getData() {
        try {
            DataSourceInfo info = new DataSourceInfo();
            String[] names = ContextUtils.getApplicationContext().getBeanNamesForType(DataSource.class);
            int index = 0;
            for (String name : names) {
                Field field;
                Class hikariCls;
                Field field2;
                if ("tracingDataSource".equals(name)) continue;
                DataSource dataSource = (DataSource)ContextUtils.getApplicationContext().getBean(name, DataSource.class);
                Class druidCls = ReflectionUtils.tryClassForName((String)"com.alibaba.druid.pool.DruidDataSource");
                if (druidCls != null && druidCls.isAssignableFrom(dataSource.getClass()) && (field2 = ReflectionUtils.findField(info.getClass(), (String)("druid" + index++))) != null) {
                    DruidDataSourceInfo druid = new DruidDataSourceInfo();
                    druid.active = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getActiveCount", null);
                    druid.connect = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getConnectCount", null);
                    druid.poolingCount = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getPoolingCount", null);
                    druid.lockQueueLength = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getLockQueueLength", null);
                    druid.waitThreadCount = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getWaitThreadCount", null);
                    druid.initialSize = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getInitialSize", null);
                    druid.maxActive = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getMaxActive", null);
                    druid.minIdle = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getMinIdle", null);
                    druid.connectErrorCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getConnectErrorCount", null);
                    druid.createTimeSpan = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getCreateTimespanMillis", null);
                    druid.closeCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getCloseCount", null);
                    druid.createCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getCreateCount", null);
                    druid.destroyCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getDestroyCount", null);
                    druid.isSharePreparedStatements = ReflectionUtils.callMethod((Object)dataSource, (String)"isSharePreparedStatements", null).toString();
                    druid.isRemoveAbandoned = ReflectionUtils.callMethod((Object)dataSource, (String)"isRemoveAbandoned", null).toString();
                    druid.removeAbandonedTimeout = (Integer)ReflectionUtils.callMethod((Object)dataSource, (String)"getRemoveAbandonedTimeout", null);
                    druid.removeAbandonedCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getRemoveAbandonedCount", null);
                    druid.rollbackCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getRollbackCount", null);
                    druid.commitCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getCommitCount", null);
                    druid.startTransactionCount = (Long)ReflectionUtils.callMethod((Object)dataSource, (String)"getStartTransactionCount", null);
                    field2.setAccessible(true);
                    ReflectionUtils.setFieldValue((Field)field2, (Object)info, (Object)druid);
                }
                if ((hikariCls = ReflectionUtils.tryClassForName((String)"com.zaxxer.hikari.HikariDataSource")) == null || !hikariCls.isAssignableFrom(dataSource.getClass()) || (field = ReflectionUtils.findField(info.getClass(), (String)("hikari" + index++))) == null) continue;
                HikariDataSourceInfo hikari = new HikariDataSourceInfo();
                Object hikariPoolMXBean = ReflectionUtils.callMethod((Object)dataSource, (String)"getHikariPoolMXBean", null);
                Object hikariConfigMXBean = ReflectionUtils.callMethod((Object)dataSource, (String)"getHikariConfigMXBean", null);
                if (ObjectUtils.isNotNull((Object)hikariPoolMXBean)) {
                    hikari.activeConnections = (Integer)ReflectionUtils.callMethod((Object)hikariPoolMXBean, (String)"getActiveConnections", null);
                    hikari.idleConnections = (Integer)ReflectionUtils.callMethod((Object)hikariPoolMXBean, (String)"getIdleConnections", null);
                    hikari.threadsAwaitingConnection = (Integer)ReflectionUtils.callMethod((Object)hikariPoolMXBean, (String)"getThreadsAwaitingConnection", null);
                    hikari.totalConnections = (Integer)ReflectionUtils.callMethod((Object)hikariPoolMXBean, (String)"getTotalConnections", null);
                }
                hikari.catalog = (String)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getCatalog", null);
                hikari.connectionTimeout = (Long)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getConnectionTimeout", null);
                hikari.idleTimeout = (Long)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getIdleTimeout", null);
                hikari.maxLifetime = (Long)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getMaxLifetime", null);
                hikari.validationTimeout = (Long)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getValidationTimeout", null);
                hikari.leakDetectionThreshold = (Long)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getLeakDetectionThreshold", null);
                hikari.maximumPoolSize = (Integer)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getMaximumPoolSize", null);
                hikari.minimumIdle = (Integer)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getMinimumIdle", null);
                hikari.poolName = (String)ReflectionUtils.callMethod((Object)hikariConfigMXBean, (String)"getPoolName", null);
                field.setAccessible(true);
                ReflectionUtils.setFieldValue((Field)field, (Object)info, (Object)hikari);
            }
            return info;
        }
        catch (Exception e) {
            if (LogUtils.isErrorEnabled()) {
                LogUtils.error((Throwable)e);
            }
            return null;
        }
    }

    private static class DataSourceInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.datasource.druid0.info", desc="druid0\u4fe1\u606f")
        private DruidDataSourceInfo druid0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid1.info", desc="druid1\u4fe1\u606f")
        private DruidDataSourceInfo druid1;
        @FieldReport(name="ttc.monitor.collect.datasource.druid2.info", desc="druid2\u4fe1\u606f")
        private DruidDataSourceInfo druid2;
        @FieldReport(name="ttc.monitor.collect.datasource.druid3.info", desc="druid3\u4fe1\u606f")
        private DruidDataSourceInfo druid3;
        @FieldReport(name="ttc.monitor.collect.datasource.druid4.info", desc="druid4\u4fe1\u606f")
        private DruidDataSourceInfo druid4;
        @FieldReport(name="ttc.monitor.collect.datasource.druid5.info", desc="druid5\u4fe1\u606f")
        private DruidDataSourceInfo druid5;
        @FieldReport(name="ttc.monitor.collect.datasource.druid6.info", desc="druid6\u4fe1\u606f")
        private DruidDataSourceInfo druid6;
        @FieldReport(name="ttc.monitor.collect.datasource.druid7.info", desc="druid7\u4fe1\u606f")
        private DruidDataSourceInfo druid7;
        @FieldReport(name="ttc.monitor.collect.datasource.druid8.info", desc="druid8\u4fe1\u606f")
        private DruidDataSourceInfo druid8;
        @FieldReport(name="ttc.monitor.collect.datasource.druid9.info", desc="druid9\u4fe1\u606f")
        private DruidDataSourceInfo druid9;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari0\u4fe1\u606f")
        private HikariDataSourceInfo hikari0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari1\u4fe1\u606f")
        private HikariDataSourceInfo hikari1;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari2\u4fe1\u606f")
        private HikariDataSourceInfo hikari2;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari3\u4fe1\u606f")
        private HikariDataSourceInfo hikari3;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari4\u4fe1\u606f")
        private HikariDataSourceInfo hikari4;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari5\u4fe1\u606f")
        private HikariDataSourceInfo hikari5;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.info", desc="hikari6\u4fe1\u606f")
        private HikariDataSourceInfo hikari6;

        private DataSourceInfo() {
        }
    }

    private static class DruidDataSourceInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.startTransaction.count", desc="druid sql \u5f00\u542f\u4e8b\u52a1\u6b21\u6570")
        private Long startTransactionCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.commit.count", desc="druid sql commit\u6b21\u6570")
        private Long commitCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.rollback.count", desc="druid sql\u56de\u6eda\u6b21\u6570")
        private Long rollbackCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.removeAbandoned.count", desc="druid \u8fde\u63a5\u8d85\u65f6\u56de\u6536\u6b21\u6570")
        private Long removeAbandonedCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.removeAbandoned.timeout", desc="druid \u8fde\u63a5\u8d85\u65f6\u56de\u6536\u5468\u671f\uff08\u79d2\uff09")
        private Integer removeAbandonedTimeout = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.isRemoveAbandoned", desc="druid \u662f\u5426\u5f00\u542f\u8fde\u63a5\u8d85\u65f6\u56de\u6536")
        private String isRemoveAbandoned = "";
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.isSharePreparedStatements", desc="druid preparedStatement\u662f\u5426\u7f13\u5b58")
        private String isSharePreparedStatements = "";
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.destroy.count", desc="druid\u9500\u6bc1\u8fde\u63a5\u6b21\u6570")
        private Long destroyCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.create.count", desc="druid\u521b\u5efa\u8fde\u63a5\u6b21\u6570")
        private Long createCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.close.count", desc="druid\u5173\u95ed\u8fde\u63a5\u6b21\u6570")
        private Long closeCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.create.timeSpan", desc="druid\u7269\u7406\u8fde\u63a5\u521b\u5efa\u8017\u65f6(\u6beb\u79d2)")
        private Long createTimeSpan = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.connect.errorCount", desc="druid\u7269\u7406\u8fde\u63a5\u9519\u8bef\u6570")
        private Long connectErrorCount = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.idle.min", desc="druid\u8fde\u63a5\u6c60\u6700\u5c0f\u503c")
        private Integer minIdle = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.active.max", desc="druid\u8fde\u63a5\u6c60\u6700\u5927\u503c")
        private Integer maxActive = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.initial.size", desc="druid\u8fde\u63a5\u6c60\u521d\u59cb\u5316\u957f\u5ea6")
        private Integer initialSize = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.waitThread.count", desc="druid\u83b7\u53d6\u8fde\u63a5\u65f6\u7b49\u5f85\u7ebf\u7a0b\u6570")
        private Integer waitThreadCount = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.lockQueue.length", desc="druid\u83b7\u53d6\u8fde\u63a5\u7b49\u5f85\u961f\u5217\u957f\u5ea6")
        private Integer lockQueueLength = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.active", desc="druid\u6b63\u5728\u6253\u5f00\u7684\u8fde\u63a5\u6570")
        private Integer active = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.connect", desc="druid\u7533\u8bf7\u8fde\u63a5\u7684\u6b21\u6570")
        private Long connect = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.druid.pool.poolingCount", desc="druid\u8fde\u63a5\u6c60\u7a7a\u95f2\u8fde\u63a5\u6570")
        private Integer poolingCount = 0;

        private DruidDataSourceInfo() {
        }
    }

    private static class HikariDataSourceInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.active.connections", desc="hikari\u5f53\u524d\u6d3b\u52a8\u8fde\u63a5\u7684\u6570\u91cf\u3002")
        private Integer activeConnections = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.idle.connections", desc="hikari\u5f53\u524d\u7a7a\u95f2\u7684\u8fde\u63a5\u6570\u3002")
        private Integer idleConnections = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.threads.awaiting.connection", desc="hikari\u7b49\u5f85\u8fde\u63a5\u7684\u7ebf\u7a0b\u6570")
        private Integer threadsAwaitingConnection = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.total.connections", desc="hikari\u8fde\u63a5\u6c60\u4e2d\u7684\u8fde\u63a5\u603b\u6570")
        private Integer totalConnections = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.catalog", desc="hikari\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u76ee\u5f55\u540d\u79f0")
        private String catalog = "";
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.connection.timeout", desc="hikari\u7b49\u5f85\u6c60\u4e2d\u8fde\u63a5\u7684\u6700\u5927\u6beb\u79d2\u6570")
        private Long connectionTimeout = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.idle.timeout", desc="hikari\u5141\u8bb8\u8fde\u63a5\u505c\u7559\u7684\u6700\u957f\u65f6\u95f4\uff08\u4ee5\u6beb\u79d2\u4e3a\u5355\u4f4d)")
        private Long idleTimeout = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.max.lifetime", desc="hikari\u8fde\u63a5\u6c60\u4e2d\u8fde\u63a5\u7684\u6700\u957f\u751f\u547d\u5468\u671f")
        private Long maxLifetime = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.validation.timeout", desc="hikari\u7b49\u5f85\u8fde\u63a5\u88ab\u9a8c\u8bc1\u4e3a\u7684\u6700\u5927\u6beb\u79d2\u6570")
        private Long validationTimeout = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.leak.detection.threshold", desc="hikari\u6d88\u606f\u53d1\u9001\u4e4b\u524d\u8fde\u63a5\u53ef\u4ee5\u79bb\u5f00\u6c60\u7684\u65f6\u95f4\u91cf.\u8bb0\u5f55\u8868\u660e\u53ef\u80fd\u7684\u8fde\u63a5\u6cc4\u6f0f")
        private Long leakDetectionThreshold = 0L;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.maximum.pool.size", desc="hikari HikariCP \u5c06\u4fdd\u7559\u5728\u6c60\u4e2d\u7684\u6700\u5927\u8fde\u63a5\u6570\uff0c\u5305\u62ec\u7a7a\u95f2\u548c\u4f7f\u7528\u4e2d\u7684\u8fde\u63a5\u3002")
        private Integer maximumPoolSize = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.minimum.idle", desc="hikari\u5c1d\u8bd5\u5728\u6c60\u4e2d\u7ef4\u62a4\u7684\u6700\u5c0f\u7a7a\u95f2\u8fde\u63a5\u6570\u3002\u5305\u62ec\u7a7a\u95f2\u548c\u4f7f\u7528\u4e2d\u7684\u8fde\u63a5")
        private Integer minimumIdle = 0;
        @FieldReport(name="ttc.monitor.collect.datasource.hikari.pool.name", desc="hikari\u7ebf\u7a0b\u6c60\u540d\u79f0")
        private String poolName = "";

        private HikariDataSourceInfo() {
        }
    }
}

