/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.Objects;

public class DoubtApiCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.doubtApi";
    private final CollectTaskProperties properties;

    public DoubtApiCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getDoubtApiTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isDoubtApiEnabled();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        block3: {
            try {
                DoubtApiInfo info = new DoubtApiInfo();
                Collector collector = Collector.getCollector();
                if (Objects.nonNull(collector)) {
                    Object doubtApiInfo = collector.value("ttc.monitor.doubtapi.info").get();
                    return info;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block3;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    public static class DoubtApiInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.doubtApi.detail", desc="\u53ef\u7591\u5185\u5b58\u589e\u957fapi\u5206\u6790\u62a5\u544a")
        String detail = "";
    }
}

