/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ScheduledThreadPoolExecutor;

public class ElasticSearchCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.elasticsearch";
    private final ThreadMXBean threadMXBean;
    private final CollectTaskProperties properties;
    private HashMap<Long, Long> lastThreadUserTime = new HashMap();
    private final boolean classExist;

    public ElasticSearchCollectTask(CollectTaskProperties properties) {
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.properties = properties;
        this.classExist = ClassUtils.isExist((String)"com.taotao.boot.monitor.elasticsearch.impl.ElasticSearchProvider");
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getElasticSearchTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isElasticSearchEnabled() && this.classExist;
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        ElasticSearchData data = new ElasticSearchData();
        if (ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)"com.taotao.boot.monitor.elasticsearch.impl.ElasticSearchProvider"), (boolean)false) != null) {
            Object transportClient;
            Collector.Hook hook = (Collector.Hook)ReflectionUtils.callMethod((Class)ReflectionUtils.tryClassForName((String)"com.taotao.boot.monitor.elasticsearch.impl.ElasticSearchMonitor"), (String)"hook", null);
            if (hook != null) {
                data.hookCurrent = hook.getCurrent();
                data.hookError = hook.getLastErrorPerSecond();
                data.hookSuccess = hook.getLastSuccessPerSecond();
                data.hookList = hook.getMaxTimeSpanList().toText();
                data.hookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
            }
            if ((transportClient = ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)"org.elasticsearch.client.transport.TransportClient"), (boolean)false)) != null) {
                Object nodesService;
                ScheduledThreadPoolExecutor scheduler;
                data.threadsTotal = 0;
                data.activateTotal = 0;
                data.queueSize = 0;
                Iterator stats = (Iterator)ReflectionUtils.tryGetValue((Object)transportClient, (String)"threadPool.stats.iterator");
                if (stats != null) {
                    stats.forEachRemaining(stat -> {
                        data.threadsTotal = data.threadsTotal + (Integer)ReflectionUtils.tryGetValue((Object)stat, (String)"threads", (Object)0);
                        data.activateTotal = data.activateTotal + (Integer)ReflectionUtils.tryGetValue((Object)stat, (String)"active", (Object)0);
                        data.queueSize = data.queueSize + (Integer)ReflectionUtils.tryGetValue((Object)stat, (String)"queue", (Object)0);
                    });
                }
                if ((scheduler = (ScheduledThreadPoolExecutor)ReflectionUtils.tryGetValue((Object)transportClient, (String)"threadPool.scheduler")) != null) {
                    ElasticSearchData elasticSearchData = data;
                    elasticSearchData.threadsTotal = elasticSearchData.threadsTotal + scheduler.getPoolSize();
                    elasticSearchData = data;
                    elasticSearchData.activateTotal = elasticSearchData.activateTotal + scheduler.getActiveCount();
                    elasticSearchData = data;
                    elasticSearchData.queueSize = elasticSearchData.queueSize + scheduler.getQueue().size();
                }
                if ((nodesService = ReflectionUtils.tryGetValue((Object)transportClient, (String)"nodesService")) != null) {
                    data.nodesCount = (Integer)ReflectionUtils.tryGetValue((Object)nodesService, (String)"listedNodes.size");
                    data.connectedCount = (Integer)ReflectionUtils.tryGetValue((Object)nodesService, (String)"nodes.size");
                    data.connectionCount = 0;
                    Collection channels = (Collection)ReflectionUtils.tryGetValue((Object)nodesService, (String)"transportService.connectionManager.connectedNodes.values");
                    if (channels != null) {
                        for (Object obj : channels) {
                            ElasticSearchData elasticSearchData = data;
                            Integer.valueOf(elasticSearchData.connectionCount + (Integer)ReflectionUtils.tryGetValue(obj, (String)"channels.size", (Object)0));
                            elasticSearchData.connectionCount = elasticSearchData.connectionCount;
                        }
                    }
                }
            }
        }
        return data;
    }

    private static class ElasticSearchData
    implements CollectInfo {
        @FieldReport(name="elasticSearch.hook.error", desc="ElasticSearch\u670d\u52a1\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long hookError;
        @FieldReport(name="elasticSearch.hook.success", desc="ElasticSearch\u670d\u52a1\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long hookSuccess;
        @FieldReport(name="elasticSearch.hook.current", desc="ElasticSearch\u670d\u52a1\u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long hookCurrent;
        @FieldReport(name="elasticSearch.hook.list.detail", desc="ElasticSearch\u670d\u52a1\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String hookList;
        @FieldReport(name="elasticSearch.hook.list.minute.detail", desc="ElasticSearch\u670d\u52a1\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String hookListPerMinute;
        @FieldReport(name="elasticSearch.node.count", desc="ElasticSearch\u96c6\u7fa4\u53d1\u73b0\u8282\u70b9\u6570")
        private Integer nodesCount;
        @FieldReport(name="elasticSearch.node.connected", desc="ElasticSearch\u96c6\u7fa4\u5df2\u8fde\u63a5\u8282\u70b9\u6570")
        private Integer connectedCount;
        @FieldReport(name="elasticSearch.node.connections", desc="ElasticSearch\u96c6\u7fa4\u8fde\u63a5\u6570")
        private Integer connectionCount;
        @FieldReport(name="elasticSearch.pool.threads.count", desc="ElasticSearch\u96c6\u7fa4\u7ebf\u7a0b\u6c60\u7ebf\u7a0b\u6570")
        private Integer threadsTotal;
        @FieldReport(name="elasticSearch.pool.threads.active", desc="ElasticSearch\u96c6\u7fa4\u6c60\u7ebf\u7a0b\u6d3b\u52a8\u7ebf\u7a0b\u6570")
        private Integer activateTotal;
        @FieldReport(name="elasticSearch.pool.queue.size", desc="ElasticSearch\u96c6\u7fa4\u6c60\u7ebf\u7a0b\u961f\u5217\u5927\u5c0f")
        private Integer queueSize;

        private ElasticSearchData() {
        }
    }
}

