/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.core.http.HttpClientManager;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.core5.pool.PoolStats;

public class HttpPoolCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.httpPool";
    private final CollectTaskProperties properties;

    public HttpPoolCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getHttpPoolTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isHttpPoolEnabled();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        try {
            HttpClientManager httpClientManager = (HttpClientManager)ContextUtils.getBean(HttpClientManager.class, (boolean)true);
            if (Objects.isNull(httpClientManager)) {
                return null;
            }
            ConcurrentHashMap pool = httpClientManager.getPool();
            if (pool == null || pool.isEmpty()) {
                return null;
            }
            HttpPoolInfo info = new HttpPoolInfo();
            StringBuilder detail = new StringBuilder();
            pool.forEach((id, client) -> {
                PoolingHttpClientConnectionManager manager = (PoolingHttpClientConnectionManager)ReflectionUtils.getFieldValue((Object)client, (String)"manager");
                PoolStats stats = manager.getTotalStats();
                info.availableCount = info.availableCount + stats.getAvailable();
                info.pendingCount = info.pendingCount + stats.getPending();
                info.leasedCount = info.leasedCount + stats.getLeased();
                detail.append(String.format("[Client\u8fde\u63a5\u6c60:%s]\r\n", id));
                detail.append(String.format("\u8def\u7531\u6570:%s\r\n", manager.getRoutes()));
                detail.append(String.format("\u8def\u7531\u8fde\u63a5\u6570:%s\r\n", manager.getDefaultMaxPerRoute()));
                detail.append(String.format("\u6700\u5927\u7684\u8fde\u63a5\u6570:%s\r\n", manager.getMaxTotal()));
                detail.append(String.format("\u53ef\u7528\u7684\u8fde\u63a5\u6570:%s\r\n", stats.getAvailable()));
                detail.append(String.format("\u7b49\u5f85\u7684\u8fde\u63a5\u6570:%s\r\n", stats.getPending()));
                detail.append(String.format("\u4f7f\u7528\u4e2d\u7684\u8fde\u63a5\u6570:%s\r\n", stats.getLeased()));
            });
            info.poolDetail = detail.toString();
            return info;
        }
        catch (Exception e) {
            if (LogUtils.isErrorEnabled()) {
                LogUtils.error((Throwable)e);
            }
            return null;
        }
    }

    private static class HttpPoolInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.httpPool.available", desc="HttpPool\u53ef\u7528\u7684\u8fde\u63a5\u6570")
        private Integer availableCount = 0;
        @FieldReport(name="ttc.monitor.collect.httpPool.pending", desc="HttpPool\u7b49\u5f85\u7684\u8fde\u63a5\u6570")
        private Integer pendingCount = 0;
        @FieldReport(name="ttc.monitor.collect.httpPool.leased", desc="HttpPool\u4f7f\u7528\u4e2d\u7684\u8fde\u63a5\u6570")
        private Integer leasedCount = 0;
        @FieldReport(name="ttc.monitor.collect.httpPool.detail", desc="HttpPool\u8be6\u60c5")
        private String poolDetail = "";

        private HttpPoolInfo() {
        }
    }
}

