/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public class LogStatisticCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.log.statistic";
    private final CollectTaskProperties properties;

    public LogStatisticCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getLogStatisticTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isLogStatisticEnabled();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        block3: {
            try {
                LogErrorInfo info = new LogErrorInfo();
                Collector collector = Collector.getCollector();
                if (Objects.nonNull(collector)) {
                    info.logerrorCount = collector.value("ttc.monitor.collect.log.error.count").get() == null ? 0 : ((AtomicLong)collector.value("ttc.monitor.collect.log.error.count").get()).intValue();
                    info.logIncreCount = collector.value("ttc.monitor.collect.log.incre.count").get() == null ? 0 : ((AtomicLong)collector.value("ttc.monitor.collect.log.incre.count").get()).intValue();
                    return info;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block3;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    private static class LogErrorInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.log.statistic.error.count", desc="\u6700\u8fd11\u5206\u949f\u9519\u8bef\u65e5\u5fd7\u6570\u91cf")
        private Integer logerrorCount = 0;
        @FieldReport(name="ttc.monitor.collect.log.statistic.incre.count", desc="\u6700\u8fd11\u5206\u949f\u65e5\u5fd7\u6761\u6570\u589e\u91cf")
        private Integer logIncreCount = 0;

        private LogErrorInfo() {
        }
    }
}

