/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import com.taotao.boot.monitor.properties.MonitorThreadPoolProperties;
import java.util.Objects;
import java.util.concurrent.ThreadPoolExecutor;

public class MonitorThreadPoolCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.executor.monitor";
    private final CollectTaskProperties properties;
    private final ThreadPoolExecutor threadPoolExecutor;

    public MonitorThreadPoolCollectTask(CollectTaskProperties properties, ThreadPoolExecutor threadPoolExecutor) {
        this.properties = properties;
        this.threadPoolExecutor = threadPoolExecutor;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getThreadPollTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isThreadPollEnabled();
    }

    @Override
    protected CollectInfo getData() {
        block3: {
            try {
                Collector collector = Collector.getCollector();
                MonitorThreadPoolProperties monitorThreadPoolProperties = (MonitorThreadPoolProperties)ContextUtils.getBean(MonitorThreadPoolProperties.class, (boolean)false);
                if (Objects.nonNull(collector) && Objects.nonNull(monitorThreadPoolProperties)) {
                    String threadNamePrefix = monitorThreadPoolProperties.getThreadNamePrefix();
                    String monitorThreadName = threadNamePrefix.replace("-", ".");
                    MonitorThreadPoolInfo info = new MonitorThreadPoolInfo();
                    info.systemActiveCount = (Integer)collector.call(monitorThreadName + ".active.count").set(this.threadPoolExecutor::getActiveCount).run();
                    info.systemCorePoolSize = (Integer)collector.call(monitorThreadName + ".core.pool.size").set(this.threadPoolExecutor::getCorePoolSize).run();
                    info.systemPoolSizeLargest = (Integer)collector.call(monitorThreadName + ".pool.size.largest").set(this.threadPoolExecutor::getLargestPoolSize).run();
                    info.systemPoolSizeMax = (Integer)collector.call(monitorThreadName + ".pool.size.max").set(this.threadPoolExecutor::getMaximumPoolSize).run();
                    info.systemPoolSizeCount = (Integer)collector.call(monitorThreadName + ".pool.size.count").set(this.threadPoolExecutor::getPoolSize).run();
                    info.systemQueueSize = (Integer)collector.call(monitorThreadName + ".queue.size").set(() -> this.threadPoolExecutor.getQueue().size()).run();
                    info.systemTaskCount = (Long)collector.call(monitorThreadName + ".task.count").set(this.threadPoolExecutor::getTaskCount).run();
                    info.systemTaskCompleted = (Long)collector.call(monitorThreadName + ".task.completed").set(this.threadPoolExecutor::getCompletedTaskCount).run();
                    Collector.Hook hook = collector.hook(monitorThreadName + ".hook");
                    info.systemTaskHookCurrent = hook.getCurrent();
                    info.systemTaskHookError = hook.getLastErrorPerSecond();
                    info.systemTaskHookSuccess = hook.getLastSuccessPerSecond();
                    info.systemTaskHookList = hook.getMaxTimeSpanList().toText();
                    info.systemTaskHookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
                    return info;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block3;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    private static class MonitorThreadPoolInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.executor.monitor.active.count", desc="\u7cfb\u7edf\u7ebf\u7a0b\u6c60\u6d3b\u52a8\u7ebf\u7a0b\u6570")
        private Integer systemActiveCount = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.core.pool.size", desc="\u7cfb\u7edf\u7ebf\u7a0b\u6c60\u6838\u5fc3\u7ebf\u7a0b\u6570")
        private Integer systemCorePoolSize = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.pool.size.largest", desc="\u7ebf\u7a0b\u6c60\u5386\u53f2\u6700\u5927\u7ebf\u7a0b\u6570")
        private Integer systemPoolSizeLargest = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.pool.size.max", desc="\u7ebf\u7a0b\u6c60\u6700\u5927\u7ebf\u7a0b\u6570")
        private Integer systemPoolSizeMax = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.pool.size.count", desc="\u7ebf\u7a0b\u6c60\u5f53\u524d\u7ebf\u7a0b\u6570")
        private Integer systemPoolSizeCount = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.queue.size", desc="\u7ebf\u7a0b\u6c60\u5f53\u524d\u6392\u961f\u7b49\u5f85\u4efb\u52a1\u6570")
        private Integer systemQueueSize = 0;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.count", desc="\u7ebf\u7a0b\u6c60\u5386\u53f2\u4efb\u52a1\u6570")
        private Long systemTaskCount = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.completed", desc="\u7ebf\u7a0b\u6c60\u5df2\u5b8c\u6210\u4efb\u52a1\u6570")
        private Long systemTaskCompleted = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.hook.error", desc="\u7ebf\u7a0b\u6c60\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long systemTaskHookError = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.hook.success", desc="\u7ebf\u7a0b\u6c60\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long systemTaskHookSuccess = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.hook.current", desc="\u7ebf\u7a0b\u6c60\u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long systemTaskHookCurrent = 0L;
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.hook.list.detail", desc="\u7ebf\u7a0b\u6c60\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String systemTaskHookList = "";
        @FieldReport(name="ttc.monitor.collect.executor.monitor.task.hook.list.minute.detail", desc="\u7ebf\u7a0b\u6c60\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String systemTaskHookListPerMinute = "";

        private MonitorThreadPoolInfo() {
        }
    }
}

