/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.Objects;

public class MybatisCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.mybatis";
    private final CollectTaskProperties properties;

    public MybatisCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getMybatisTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isMybatisEnabled();
    }

    @Override
    protected CollectInfo getData() {
        block3: {
            try {
                SqlMybatisInfo info = new SqlMybatisInfo();
                Collector collector = Collector.getCollector();
                if (Objects.nonNull(collector)) {
                    Collector.Hook hook = collector.hook("ttc.monitor.mybatis.sql.hook");
                    info.hookCurrent = hook.getCurrent();
                    info.hookError = hook.getLastErrorPerSecond();
                    info.hookSuccess = hook.getLastSuccessPerSecond();
                    info.hookList = hook.getMaxTimeSpanList().toText();
                    info.hookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
                    return info;
                }
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block3;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    private static class SqlMybatisInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.mybatis.sql.hook.error", desc="mybatis \u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long hookError = 0L;
        @FieldReport(name="ttc.monitor.collect.mybatis.sql.hook.success", desc="mybatis \u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long hookSuccess = 0L;
        @FieldReport(name="ttc.monitor.collect.mybatis.sql.hook.current", desc="mybatis \u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long hookCurrent = 0L;
        @FieldReport(name="ttc.monitor.collect.mybatis.sql.hook.list.detail", desc="mybatis \u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String hookList = "";
        @FieldReport(name="ttc.monitor.collect.mybatis.sql.hook.list.minute.detail", desc="mybatis \u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String hookListPerMinute = "";

        private SqlMybatisInfo() {
        }
    }
}

