/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.ListView;
import com.alibaba.nacos.api.naming.pojo.ServiceInfo;
import com.alibaba.nacos.client.naming.NacosNamingService;
import com.taotao.boot.common.constant.CommonConstants;
import com.taotao.boot.common.model.Lazy;
import com.taotao.boot.common.utils.common.PropertyUtils;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NacosCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.nacos";
    private final CollectTaskProperties collectTaskProperties;
    private final Lazy<Boolean> lazy = Lazy.of(() -> ClassUtils.isExist((String)"com.alibaba.cloud.nacos.NacosServiceManager"));

    public NacosCollectTask(CollectTaskProperties collectTaskProperties) {
        this.collectTaskProperties = collectTaskProperties;
    }

    @Override
    public int getTimeSpan() {
        return this.collectTaskProperties.getNacosTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.collectTaskProperties.isNacosEnabled() && Boolean.TRUE.equals(this.lazy.get());
    }

    @Override
    protected CollectInfo getData() {
        block4: {
            try {
                Collector collector = Collector.getCollector();
                Object nacosServiceManager = ContextUtils.getBean((String)"com.alibaba.cloud.nacos.NacosServiceManager", (boolean)false);
                if (!Objects.nonNull(collector) || !Objects.nonNull(nacosServiceManager)) break block4;
                NacosClientInfo info = new NacosClientInfo();
                try {
                    NamingService namingService = (NamingService)ReflectionUtils.getFieldValue((Object)nacosServiceManager, (String)"namingService");
                    NacosNamingService nacosNamingService = (NacosNamingService)namingService;
                    info.namespace = (String)ReflectionUtils.getFieldValue((Object)nacosNamingService, (String)"namespace");
                    info.logName = (String)ReflectionUtils.getFieldValue((Object)nacosNamingService, (String)"logName");
                    info.instances = nacosNamingService.getAllInstances(PropertyUtils.getProperty((String)CommonConstants.SPRING_APP_NAME_KEY), CommonConstants.SPRING_APP_NAME_KEY);
                    info.servicesOfServer = nacosNamingService.getServicesOfServer(0, Integer.MAX_VALUE);
                    info.subscribeServices = nacosNamingService.getSubscribeServices();
                    info.serverStatus = nacosNamingService.getServerStatus();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return info;
            }
            catch (Exception e) {
                if (!LogUtils.isErrorEnabled()) break block4;
                LogUtils.error((Throwable)e);
            }
        }
        return null;
    }

    private static class NacosClientInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.nacos.namespace", desc="nacos namespace")
        private String namespace = "";
        @FieldReport(name="ttc.monitor.collect.nacos.endpoint", desc="nacos endpoint")
        private String endpoint = "";
        @FieldReport(name="ttc.monitor.collect.nacos.serverList", desc="nacos serverList")
        private String serverList = "";
        @FieldReport(name="ttc.monitor.collect.nacos.cacheDir", desc="nacos cacheDir")
        private String cacheDir = "";
        @FieldReport(name="ttc.monitor.collect.nacos.logName", desc="nacos logName")
        private String logName = "";
        @FieldReport(name="ttc.monitor.collect.nacos.serverStatus", desc="nacos serverStatus")
        private String serverStatus = "";
        @FieldReport(name="ttc.monitor.collect.nacos.instances", desc="nacos instances")
        private List<Instance> instances;
        @FieldReport(name="ttc.monitor.collect.nacos.serviceInfoMap", desc="nacos serviceInfoMap")
        private Map<String, ServiceInfo> serviceInfoMap;
        @FieldReport(name="ttc.monitor.collect.nacos.servicesOfServer", desc="nacos servicesOfServer")
        private ListView<String> servicesOfServer;
        @FieldReport(name="ttc.monitor.collect.nacos.subscribeServices", desc="nacos subscribeServices")
        private List<ServiceInfo> subscribeServices;

        private NacosClientInfo() {
        }
    }
}

