/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.exception.BaseException;
import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.core.support.Collector;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;

public class RocketMQCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.rocket";
    private final ThreadMXBean threadMXBean;
    private final CollectTaskProperties properties;
    private HashMap<Long, Long> lastThreadUserTime = new HashMap();
    private final boolean classExist;

    public RocketMQCollectTask(CollectTaskProperties properties) {
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.properties = properties;
        this.classExist = ClassUtils.isExist((String)"com.taotao.boot.monitor.rocketmq.RocketMQConsumerProvider");
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getRocketMQTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isRocketMQEnabled() && this.classExist;
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        Collector.Hook hook;
        RocketMQInfo data = new RocketMQInfo();
        if (ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)"com.taotao.boot.monitor.rocketmq.RocketMQConsumerProvider"), (boolean)false) != null) {
            hook = this.getCollectorHook("com.taotao.boot.monitor.rocketmq.RocketMQMonitor");
            data.consumerHookCurrent = hook.getCurrent();
            data.consumerHookError = hook.getLastErrorPerSecond();
            data.consumerHookSuccess = hook.getLastSuccessPerSecond();
            data.consumerHookList = hook.getMaxTimeSpanList().toText();
            data.consumerHookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
        }
        if (ContextUtils.getBean((Class)ReflectionUtils.tryClassForName((String)"com.taotao.boot.monitor.rocketmq.RocketMQProducerProvider"), (boolean)false) != null) {
            hook = this.getCollectorHook("com.taotao.boot.monitor.rocketmq.RocketMQMonitor");
            data.producerHookCurrent = hook.getCurrent();
            data.producerHookError = hook.getLastErrorPerSecond();
            data.producerHookSuccess = hook.getLastSuccessPerSecond();
            data.producerHookList = hook.getMaxTimeSpanList().toText();
            data.producerHookListPerMinute = hook.getMaxTimeSpanListPerMinute().toText();
        }
        return data;
    }

    private Collector.Hook getCollectorHook(String className) {
        Class monitor = ReflectionUtils.classForName((String)className);
        try {
            return (Collector.Hook)ReflectionUtils.findMethod((Class)monitor, (String)"hook").invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    private static class RocketMQInfo
    implements CollectInfo {
        @FieldReport(name="rocketmq.consumer.hook.error", desc="Consumer\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long consumerHookError;
        @FieldReport(name="rocketmq.consumer.hook.success", desc="Consumer\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long consumerHookSuccess;
        @FieldReport(name="rocketmq.consumer.hook.current", desc="Consumer\u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long consumerHookCurrent;
        @FieldReport(name="rocketmq.consumer.hook.list.detail", desc="Consumer\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String consumerHookList;
        @FieldReport(name="rocketmq.consumer.hook.list.minute.detail", desc="Consumer\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String consumerHookListPerMinute;
        @FieldReport(name="rocketmq.producer.hook.error", desc="Producer\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u51fa\u9519\u6b21\u6570")
        private Long producerHookError;
        @FieldReport(name="rocketmq.producer.hook.success", desc="Producer\u62e6\u622a\u4e0a\u4e00\u6b21\u6bcf\u79d2\u6210\u529f\u6b21\u6570")
        private Long producerHookSuccess;
        @FieldReport(name="rocketmq.producer.hook.current", desc="Producer\u62e6\u622a\u5f53\u524d\u6267\u884c\u4efb\u52a1\u6570")
        private Long producerHookCurrent;
        @FieldReport(name="rocketmq.producer.hook.list.detail", desc="Producer\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868")
        private String producerHookList;
        @FieldReport(name="rocketmq.producer.hook.list.minute.detail", desc="Producer\u62e6\u622a\u5386\u53f2\u6700\u5927\u8017\u65f6\u4efb\u52a1\u5217\u8868(\u6bcf\u5206\u949f)")
        private String producerHookListPerMinute;

        private RocketMQInfo() {
        }
    }
}

