/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.exception.ExceptionUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;

public class ThreadCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.thread";
    private final ThreadMXBean threadMXBean;
    private final CollectTaskProperties properties;
    private HashMap<Long, Long> lastThreadUserTime = new HashMap();

    public ThreadCollectTask(CollectTaskProperties properties) {
        this.threadMXBean = ManagementFactory.getThreadMXBean();
        this.properties = properties;
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getMonitorThreadTimeSpan();
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isMonitorThreadEnabled();
    }

    @Override
    protected CollectInfo getData() {
        try {
            ThreadInfo threadInfo = new ThreadInfo();
            long[] deadlockedThreads = this.threadMXBean.findDeadlockedThreads();
            threadInfo.deadlockedThreadCount = deadlockedThreads == null ? 0 : deadlockedThreads.length;
            threadInfo.threadCount = this.threadMXBean.getThreadCount();
            java.lang.management.ThreadInfo runable = null;
            java.lang.management.ThreadInfo wait = null;
            java.lang.management.ThreadInfo block = null;
            HashMap<Long, Long> treadUserTime = new HashMap<Long, Long>();
            for (java.lang.management.ThreadInfo info : this.threadMXBean.dumpAllThreads(false, false)) {
                ThreadInfo threadInfo2;
                treadUserTime.put(info.getThreadId(), this.threadMXBean.getThreadUserTime(info.getThreadId()));
                if (info.getThreadState() == Thread.State.RUNNABLE) {
                    threadInfo2 = threadInfo;
                    Integer.valueOf(threadInfo2.runnableThreadCount + 1);
                    threadInfo2.runnableThreadCount = threadInfo2.runnableThreadCount;
                    if (runable == null) {
                        runable = info;
                        continue;
                    }
                    Long lastvalue = this.lastThreadUserTime.get(info.getThreadId());
                    lastvalue = lastvalue == null ? 0L : lastvalue;
                    Long runablevalue = this.lastThreadUserTime.get(runable.getThreadId());
                    runablevalue = runablevalue == null ? 0L : runablevalue;
                    if (this.threadMXBean.getThreadUserTime(runable.getThreadId()) - runablevalue >= this.threadMXBean.getThreadUserTime(info.getThreadId()) - lastvalue) continue;
                    runable = info;
                    continue;
                }
                if (info.getThreadState() == Thread.State.BLOCKED) {
                    threadInfo2 = threadInfo;
                    Integer.valueOf(threadInfo2.blockedThreadCount + 1);
                    threadInfo2.blockedThreadCount = threadInfo2.blockedThreadCount;
                    if (block == null) {
                        block = info;
                        continue;
                    }
                    if (block.getBlockedTime() >= info.getBlockedTime()) continue;
                    block = info;
                    continue;
                }
                if (info.getThreadState() != Thread.State.WAITING) continue;
                threadInfo2 = threadInfo;
                Integer.valueOf(threadInfo2.waitingThreadCount + 1);
                threadInfo2.waitingThreadCount = threadInfo2.waitingThreadCount;
                if (wait == null) {
                    wait = info;
                    continue;
                }
                if (wait.getWaitedTime() >= info.getWaitedTime()) continue;
                wait = info;
            }
            this.lastThreadUserTime = treadUserTime;
            if (runable != null) {
                threadInfo.maxRunnableDetail = ExceptionUtils.trace2String((StackTraceElement[])runable.getStackTrace());
            }
            if (wait != null) {
                threadInfo.maxWaitingDetail = ExceptionUtils.trace2String((StackTraceElement[])wait.getStackTrace());
            }
            if (block != null) {
                threadInfo.maxBlockedDetail = ExceptionUtils.trace2String((StackTraceElement[])block.getStackTrace());
            }
            return threadInfo;
        }
        catch (Exception e) {
            if (LogUtils.isErrorEnabled()) {
                LogUtils.error((Throwable)e);
            }
            return null;
        }
    }

    private static class ThreadInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.thread.deadlocked.count", desc="\u6b7b\u9501\u7ebf\u7a0b\u6570")
        private Integer deadlockedThreadCount = 0;
        @FieldReport(name="ttc.monitor.collect.thread.total", desc="\u7ebf\u7a0b\u603b\u6570")
        private Integer threadCount = 0;
        @FieldReport(name="ttc.monitor.collect.thread.runnable.count", desc="\u8fd0\u884c\u7ebf\u7a0b\u603b\u6570")
        private Integer runnableThreadCount = 0;
        @FieldReport(name="ttc.monitor.collect.thread.blocked.count", desc="\u963b\u585e\u7ebf\u7a0b\u603b\u6570")
        private Integer blockedThreadCount = 0;
        @FieldReport(name="ttc.monitor.collect.thread.waiting.count", desc="\u7b49\u5f85\u7ebf\u7a0b\u603b\u6570")
        private Integer waitingThreadCount = 0;
        @FieldReport(name="ttc.monitor.collect.thread.runnable.max.detail", desc="\u6700\u8fd1\u8fd0\u884c\u6700\u8017\u65f6\u7684\u7ebf\u7a0b\u8be6\u60c5")
        private String maxRunnableDetail = "";
        @FieldReport(name="ttc.monitor.collect.thread.blocked.max.detail", desc="\u963b\u585e\u6700\u8017\u65f6\u7684\u7ebf\u7a0b\u8be6\u60c5")
        private String maxBlockedDetail = "";
        @FieldReport(name="ttc.monitor.collect.thread.waiting.max.detail", desc="\u7b49\u5f85\u6700\u8017\u65f6\u7684\u7ebf\u7a0b\u8be6\u60c5")
        private String maxWaitingDetail = "";

        private ThreadInfo() {
        }
    }
}

