/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.exception.ExceptionUtils;
import com.taotao.boot.common.utils.lang.StringUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.enums.WarnTypeEnum;
import com.taotao.boot.monitor.properties.CollectTaskProperties;

public class UnCatchExceptionCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.unCatchException";
    private Throwable lastException = null;
    private final CollectTaskProperties properties;

    public UnCatchExceptionCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (!(handler instanceof DefaultUncaughtExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(this, handler));
        }
    }

    @Override
    public int getTimeSpan() {
        return -1;
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isUncatchEnabled();
    }

    @Override
    protected CollectInfo getData() {
        return new UnCatchInfo(StringUtils.nullToEmpty((Object)ExceptionUtils.trace2String((Throwable)this.lastException)));
    }

    @Override
    public void close() throws Exception {
        Thread.UncaughtExceptionHandler handler = Thread.getDefaultUncaughtExceptionHandler();
        if (handler instanceof DefaultUncaughtExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(((DefaultUncaughtExceptionHandler)handler).lastUncaughtExceptionHandler);
        }
    }

    public static class DefaultUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler lastUncaughtExceptionHandler;
        private final UnCatchExceptionCollectTask unCatchExceptionCheckTask;

        public DefaultUncaughtExceptionHandler(UnCatchExceptionCollectTask unCatchExceptionCheckTask, Thread.UncaughtExceptionHandler lastUncaughtExceptionHandler) {
            this.unCatchExceptionCheckTask = unCatchExceptionCheckTask;
            this.lastUncaughtExceptionHandler = lastUncaughtExceptionHandler;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            block4: {
                try {
                    if (e != null) {
                        this.unCatchExceptionCheckTask.lastException = e;
                        AbstractCollectTask.notifyMessage(WarnTypeEnum.ERROR, "\u672a\u6355\u83b7\u9519\u8bef", ExceptionUtils.trace2String((Throwable)e));
                        LogUtils.error((Throwable)e, (String)"\u672a\u6355\u83b7\u9519\u8bef", (Object[])new Object[0]);
                    }
                }
                catch (Exception e2) {
                    if (!LogUtils.isErrorEnabled()) break block4;
                    LogUtils.error((Throwable)e);
                }
            }
            if (this.lastUncaughtExceptionHandler != null) {
                this.lastUncaughtExceptionHandler.uncaughtException(t, e);
            }
        }
    }

    private static class UnCatchInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.unCatchException.trace", desc="\u672a\u6355\u83b7\u9519\u8bef\u5806\u6808")
        private String trace = "";

        public UnCatchInfo(String trace) {
            this.trace = trace;
        }
    }
}

