/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.collect.task;

import com.taotao.boot.common.utils.context.ContextUtils;
import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.common.utils.reflect.ClassUtils;
import com.taotao.boot.common.utils.reflect.ReflectionUtils;
import com.taotao.boot.monitor.annotation.FieldReport;
import com.taotao.boot.monitor.collect.AbstractCollectTask;
import com.taotao.boot.monitor.collect.CollectInfo;
import com.taotao.boot.monitor.properties.CollectTaskProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import com.xxl.job.core.handler.annotation.XxlJob;
import java.util.Objects;

public class XxlJobCollectTask
extends AbstractCollectTask {
    private static final String TASK_NAME = "ttc.monitor.collect.xxljob";
    private final CollectTaskProperties properties;
    private final boolean classExist;

    public XxlJobCollectTask(CollectTaskProperties properties) {
        this.properties = properties;
        this.classExist = ClassUtils.isExist((String)"com.xxl.job.core.executor.impl.XxlJobSpringExecutor");
    }

    @Override
    public int getTimeSpan() {
        return this.properties.getXxljobTimeSpan();
    }

    @Override
    public boolean getEnabled() {
        return this.properties.isXxljobEnabled() && this.classExist;
    }

    @Override
    public String getDesc() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    protected CollectInfo getData() {
        try {
            Object adminBizList;
            XxlJobSpringExecutor xxlJobSpringExecutor = (XxlJobSpringExecutor)ContextUtils.getBean(XxlJobSpringExecutor.class, (boolean)true);
            if (Objects.isNull(xxlJobSpringExecutor)) {
                return null;
            }
            JobInfo data = new JobInfo();
            data.count = ContextUtils.getApplicationContext().getBeanNamesForAnnotation(XxlJob.class).length;
            Object jobThreadRepository = ReflectionUtils.tryGetFieldValue((Object)xxlJobSpringExecutor, (String)"jobThreadRepository", null);
            if (Objects.nonNull(jobThreadRepository)) {
                data.jobThreadRepository = (Integer)ReflectionUtils.callMethod((Object)jobThreadRepository, (String)"size", null);
            }
            Object jobHandlerRepository = ReflectionUtils.tryGetFieldValue((Object)xxlJobSpringExecutor, (String)"jobHandlerRepository", null);
            if (Objects.nonNull(jobThreadRepository)) {
                data.jobHandlerRepository = (Integer)ReflectionUtils.callMethod((Object)jobHandlerRepository, (String)"size", null);
            }
            if (Objects.nonNull(adminBizList = ReflectionUtils.tryGetFieldValue((Object)xxlJobSpringExecutor, (String)"adminBizList", null))) {
                data.adminBizList = (Integer)ReflectionUtils.callMethod((Object)adminBizList, (String)"size", null);
            }
            data.logRetentionDays = (Integer)ReflectionUtils.tryGetValue((Object)xxlJobSpringExecutor, (String)"logRetentionDays");
            return data;
        }
        catch (Exception e) {
            if (LogUtils.isErrorEnabled()) {
                LogUtils.error((Throwable)e);
            }
            return null;
        }
    }

    private static class JobInfo
    implements CollectInfo {
        @FieldReport(name="ttc.monitor.collect.xxljob.count", desc="xxljob\u4efb\u52a1\u6570\u91cf")
        private Integer count = 0;
        @FieldReport(name="ttc.monitor.collect.xxljob.job.thread.repository", desc="xxljob thread repository\u6570\u91cf")
        private Integer jobThreadRepository = 0;
        @FieldReport(name="ttc.monitor.collect.xxljob.job.handler.repository", desc="xxljob handler repository \u6570\u91cf")
        private Integer jobHandlerRepository = 0;
        @FieldReport(name="ttc.monitor.collect.xxljob.admin.biz.list", desc="xxljob admin biz \u6570\u91cf")
        private Integer adminBizList = 0;
        @FieldReport(name="ttc.monitor.collect.xxljob.log.retention.days", desc="xxljob\u65e5\u5fd7\u4fdd\u7559\u5929\u6570")
        private Integer logRetentionDays = 0;

        private JobInfo() {
        }
    }
}

