/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.dump.DumpFilter;
import com.taotao.boot.monitor.dump.DumpProvider;
import com.taotao.boot.monitor.properties.DumpProperties;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={DumpProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.monitor.dump", name={"enabled"}, havingValue="true")
public class DumpProviderAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(DumpProviderAutoConfiguration.class, (String)"taotao-boot-starter-monitor", (String[])new String[0]);
    }

    @Bean
    public DumpProvider dumpProvider() {
        return new DumpProvider();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public FilterRegistrationBean<DumpFilter> dumpFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setOrder(-2147483647);
        filterRegistrationBean.setFilter((Filter)new DumpFilter());
        filterRegistrationBean.setName(DumpFilter.class.getName());
        filterRegistrationBean.addUrlPatterns(new String[]{"/health/dump/*"});
        return filterRegistrationBean;
    }
}

