/*
 * Decompiled with CFR 0.152.
 */
package com.taotao.boot.monitor.configuration;

import com.taotao.boot.common.utils.log.LogUtils;
import com.taotao.boot.monitor.Monitor;
import com.taotao.boot.monitor.collect.HealthCheckProvider;
import com.taotao.boot.monitor.export.ExportProvider;
import com.taotao.boot.monitor.properties.ExportProperties;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={ExportProperties.class})
@ConditionalOnProperty(prefix="taotao.boot.monitor.export", name={"enabled"}, havingValue="true")
public class ExportProviderAutoConfiguration
implements InitializingBean {
    public void afterPropertiesSet() throws Exception {
        LogUtils.started(ExportProviderAutoConfiguration.class, (String)"taotao-boot-starter-monitor", (String[])new String[0]);
    }

    @Bean(initMethod="start", destroyMethod="close")
    @ConditionalOnBean
    public ExportProvider getExportProvider(Monitor monitor, ExportProperties exportProperties, HealthCheckProvider healthCheckProvider) {
        return new ExportProvider(monitor, exportProperties, healthCheckProvider);
    }
}

